/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.http.internal.Http3;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;

public final class HttpResources
extends TcpResources {
    final AtomicReference<ConnectionProvider> http2ConnectionProvider = new AtomicReference();
    final AtomicReference<ConnectionProvider> http3ConnectionProvider = new AtomicReference();
    static final BiFunction<LoopResources, ConnectionProvider, HttpResources> ON_HTTP_NEW = HttpResources::new;
    static final AtomicReference<HttpResources> httpResources = new AtomicReference();

    public static void disposeLoopsAndConnections() {
        HttpResources resources = httpResources.getAndSet(null);
        if (resources != null) {
            ConnectionProvider providerHttp3;
            ConnectionProvider providerHttp2 = resources.http2ConnectionProvider.get();
            if (providerHttp2 != null) {
                providerHttp2.dispose();
            }
            if ((providerHttp3 = resources.http3ConnectionProvider.get()) != null) {
                providerHttp3.dispose();
            }
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return HttpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            HttpResources resources = httpResources.getAndSet(null);
            if (resources != null) {
                ConnectionProvider providerHttp2 = resources.http2ConnectionProvider.get();
                Mono<Object> disposeProviderHttp2 = Mono.empty();
                if (providerHttp2 != null) {
                    disposeProviderHttp2 = providerHttp2.disposeLater();
                }
                ConnectionProvider providerHttp3 = resources.http3ConnectionProvider.get();
                Mono<Object> disposeProviderHttp3 = Mono.empty();
                if (providerHttp3 != null) {
                    disposeProviderHttp3 = providerHttp3.disposeLater();
                }
                return Mono.when(disposeProviderHttp2, disposeProviderHttp3, resources._disposeLater(quietPeriod, timeout));
            }
            return Mono.empty();
        });
    }

    public static HttpResources get() {
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources reset() {
        HttpResources.disposeLoopsAndConnections();
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(ConnectionProvider provider) {
        return HttpResources.getOrCreate(httpResources, null, provider, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(LoopResources loops) {
        return HttpResources.getOrCreate(httpResources, loops, null, ON_HTTP_NEW, "http");
    }

    HttpResources(LoopResources loops, ConnectionProvider provider) {
        super(loops, provider);
    }

    @Override
    public void disposeWhen(SocketAddress remoteAddress) {
        ConnectionProvider providerHttp3;
        ConnectionProvider providerHttp2 = this.http2ConnectionProvider.get();
        if (providerHttp2 != null) {
            providerHttp2.disposeWhen(remoteAddress);
        }
        if ((providerHttp3 = this.http3ConnectionProvider.get()) != null) {
            providerHttp3.disposeWhen(remoteAddress);
        }
        super.disposeWhen(remoteAddress);
    }

    @Override
    public AddressResolverGroup<?> getOrCreateDefaultResolver() {
        return super.getOrCreateDefaultResolver();
    }

    public ConnectionProvider getOrCreateHttp2ConnectionProvider(Function<ConnectionProvider, ConnectionProvider> create) {
        ConnectionProvider provider = this.http2ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = create.apply(this);
            if (!this.http2ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreateHttp2ConnectionProvider(create);
        }
        return provider;
    }

    public ConnectionProvider getOrCreateHttp3ConnectionProvider(Function<ConnectionProvider, ConnectionProvider> create) {
        if (!Http3.isHttp3Available()) {
            throw new UnsupportedOperationException("To enable HTTP/3 support, you must add the dependency `io.netty.incubator:netty-incubator-codec-http3` to the class path first");
        }
        ConnectionProvider provider = this.http3ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = create.apply(this);
            if (!this.http3ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreateHttp3ConnectionProvider(create);
        }
        return provider;
    }
}

