/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.internal.shaded.reactor.pool.AbstractPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

public class SimpleDequePool<POOLABLE>
extends AbstractPool<POOLABLE> {
    private static final ConcurrentLinkedDeque TERMINATED = new ConcurrentLinkedDeque();
    final boolean idleResourceLeastRecentlyUsed;
    volatile Deque<QueuePooledRef<POOLABLE>> idleResources;
    protected static final AtomicReferenceFieldUpdater<SimpleDequePool, Deque> IDLE_RESOURCES = AtomicReferenceFieldUpdater.newUpdater(SimpleDequePool.class, Deque.class, "idleResources");
    volatile int acquired;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> ACQUIRED = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "acquired");
    volatile int wip;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> WIP = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "wip");
    volatile ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> pending;
    private static final AtomicReferenceFieldUpdater<SimpleDequePool, ConcurrentLinkedDeque> PENDING = AtomicReferenceFieldUpdater.newUpdater(SimpleDequePool.class, ConcurrentLinkedDeque.class, "pending");
    volatile int pendingSize;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> PENDING_SIZE = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "pendingSize");
    volatile int idleSize;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> IDLE_SIZE = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "idleSize");
    Disposable evictionTask;

    SimpleDequePool(PoolConfig<POOLABLE> poolConfig) {
        super(poolConfig, Loggers.getLogger(SimpleDequePool.class));
        this.idleResourceLeastRecentlyUsed = poolConfig.reuseIdleResourcesInLruOrder();
        this.pending = new ConcurrentLinkedDeque();
        this.idleResources = new ConcurrentLinkedDeque<QueuePooledRef<POOLABLE>>();
        this.recordInteractionTimestamp();
        this.scheduleEviction();
    }

    @Override
    public Mono<PooledRef<POOLABLE>> acquire() {
        return new QueueBorrowerMono(this, Duration.ZERO);
    }

    @Override
    public Mono<PooledRef<POOLABLE>> acquire(Duration timeout) {
        return new QueueBorrowerMono(this, timeout);
    }

    @Override
    public int acquiredSize() {
        return this.acquired;
    }

    void scheduleEviction() {
        if (!this.poolConfig.evictInBackgroundInterval().isZero()) {
            long nanosEvictionInterval = this.poolConfig.evictInBackgroundInterval().toNanos();
            this.evictionTask = this.poolConfig.evictInBackgroundScheduler().schedule(this::evictInBackground, nanosEvictionInterval, TimeUnit.NANOSECONDS);
        } else {
            this.evictionTask = Disposables.disposed();
        }
    }

    void evictInBackground() {
        Queue e = IDLE_RESOURCES.get(this);
        if (e == null) {
            return;
        }
        if (WIP.getAndIncrement(this) == 0) {
            if (this.pendingSize == 0) {
                BiPredicate evictionPredicate = this.poolConfig.evictionPredicate();
                Iterator iterator = e.iterator();
                while (iterator.hasNext()) {
                    QueuePooledRef pooledRef = (QueuePooledRef)iterator.next();
                    if (!evictionPredicate.test(pooledRef.poolable, pooledRef) || !pooledRef.markDestroy()) continue;
                    this.recordInteractionTimestamp();
                    iterator.remove();
                    this.decrementIdle();
                    this.destroyPoolable(pooledRef).subscribe(v -> {}, destroyError -> this.logger.warn("Error while destroying resource in background eviction:", (Throwable)destroyError));
                }
            }
            if (WIP.decrementAndGet(this) > 0) {
                this.drainLoop();
            }
        }
        this.scheduleEviction();
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            this.recordInteractionTimestamp();
            ConcurrentLinkedDeque q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                AbstractPool.Borrower p;
                this.evictionTask.dispose();
                while ((p = (AbstractPool.Borrower)q.pollFirst()) != null) {
                    p.fail(new PoolShutdownException());
                }
                PENDING_SIZE.set(this, 0);
                Queue e = IDLE_RESOURCES.getAndSet(this, null);
                if (e != null) {
                    Mono<Object> destroyMonos = Mono.empty();
                    while (!e.isEmpty()) {
                        QueuePooledRef ref = (QueuePooledRef)e.poll();
                        if (!ref.markDestroy()) continue;
                        this.decrementIdle();
                        destroyMonos = destroyMonos.and(this.destroyPoolable(ref));
                    }
                    return destroyMonos;
                }
            }
            return Mono.empty();
        });
    }

    @Override
    public int idleSize() {
        return this.idleSize;
    }

    @Override
    public Mono<Integer> warmup() {
        if (this.poolConfig.allocationStrategy().permitMinimum() > 0) {
            return Mono.deferContextual(ctx -> {
                this.recordInteractionTimestamp();
                int initSize = this.poolConfig.allocationStrategy().getPermits(0);
                if (initSize <= 0) {
                    return Mono.just(0);
                }
                Mono[] allWarmups = new Mono[initSize];
                for (int i = 0; i < initSize; ++i) {
                    long start = this.clock.millis();
                    allWarmups[i] = this.poolConfig.allocator().contextWrite((ContextView)ctx).doOnNext(p -> {
                        this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start);
                        this.incrementIdle();
                        this.idleResources.offerLast(this.createSlot(p));
                    }).doOnError(e -> {
                        this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                        this.poolConfig.allocationStrategy().returnPermits(1);
                    });
                }
                int mergeConcurrency = Math.min(this.poolConfig.allocationStrategy().warmupParallelism(), allWarmups.length);
                return Flux.merge(Flux.fromArray(allWarmups), mergeConcurrency).reduce(0, (count, p) -> count + 1);
            });
        }
        return Mono.just(0);
    }

    void decrementIdle() {
        if (IDLE_SIZE.decrementAndGet(this) < 0) {
            System.err.println("unexpected decrement below 0");
        }
    }

    void incrementIdle() {
        if (IDLE_SIZE.incrementAndGet(this) == 0) {
            System.err.println("unexpected increment from below 0");
        }
    }

    @Override
    void cancelAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> q;
        if (!this.isDisposed() && (q = this.pending).remove(borrower)) {
            PENDING_SIZE.decrementAndGet(this);
        }
    }

    QueuePooledRef<POOLABLE> createSlot(POOLABLE element) {
        return new QueuePooledRef<POOLABLE>(this, element);
    }

    @Override
    void doAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        if (borrower.get()) {
            return;
        }
        if (this.isDisposed()) {
            borrower.fail(new PoolShutdownException());
            return;
        }
        this.pendingOffer(borrower);
        this.drain();
    }

    void drain() {
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    private void drainLoop() {
        this.recordInteractionTimestamp();
        int maxPending = this.poolConfig.maxPending();
        while (true) {
            Deque resources = IDLE_RESOURCES.get(this);
            ConcurrentLinkedDeque borrowers = PENDING.get(this);
            if (resources == null || borrowers == TERMINATED) {
                return;
            }
            int borrowersCount = this.pendingSize;
            int resourcesCount = this.idleSize;
            if (borrowersCount != 0) {
                AbstractPool.Borrower borrower;
                if (resourcesCount > 0) {
                    QueuePooledRef slot;
                    QueuePooledRef queuePooledRef = slot = this.idleResourceLeastRecentlyUsed ? (QueuePooledRef)resources.pollFirst() : (QueuePooledRef)resources.pollLast();
                    if (slot == null) continue;
                    this.decrementIdle();
                    if (this.poolConfig.evictionPredicate().test(slot.poolable, slot)) {
                        if (!slot.markDestroy()) continue;
                        this.destroyPoolable(slot).subscribe(null, error -> this.drain(), this::drain);
                        continue;
                    }
                    borrower = this.pendingPoll(borrowers);
                    if (borrower == null || borrower.get()) {
                        if (this.idleResourceLeastRecentlyUsed) {
                            resources.offerFirst(slot);
                        } else {
                            resources.offerLast(slot);
                        }
                        this.incrementIdle();
                        continue;
                    }
                    if (this.isDisposed()) {
                        slot.invalidate().subscribe();
                        borrower.fail(new PoolShutdownException());
                        return;
                    }
                    borrower.stopPendingCountdown(true);
                    ACQUIRED.incrementAndGet(this);
                    this.poolConfig.acquisitionScheduler().schedule(() -> borrower.deliver(slot));
                } else {
                    int permits = this.poolConfig.allocationStrategy().getPermits(1);
                    if (permits <= 0) {
                        if (maxPending >= 0) {
                            borrowersCount = this.pendingSize;
                            int toCull = borrowersCount - maxPending;
                            for (int i2 = 0; i2 < toCull; ++i2) {
                                AbstractPool.Borrower<POOLABLE> extraneous = this.pendingPoll(borrowers);
                                if (extraneous == null) continue;
                                if (maxPending == 0) {
                                    extraneous.fail(new PoolAcquirePendingLimitException(0, "No pending allowed and pool has reached allocation limit"));
                                    continue;
                                }
                                extraneous.fail(new PoolAcquirePendingLimitException(maxPending));
                            }
                        }
                    } else {
                        borrower = this.pendingPoll(borrowers);
                        if (borrower == null || borrower.get()) {
                            this.poolConfig.allocationStrategy().returnPermits(permits);
                            continue;
                        }
                        if (this.isDisposed()) {
                            borrower.fail(new PoolShutdownException());
                            return;
                        }
                        borrower.stopPendingCountdown(true);
                        long start = this.clock.millis();
                        Mono<POOLABLE> allocator = this.allocatorWithScheduler();
                        Mono<POOLABLE> primary = allocator.doOnEach(sig -> {
                            if (sig.isOnNext()) {
                                Object newInstance = sig.get();
                                assert (newInstance != null);
                                ACQUIRED.incrementAndGet(this);
                                this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start);
                                borrower.deliver(this.createSlot(newInstance));
                            } else if (sig.isOnError()) {
                                Throwable error = sig.getThrowable();
                                assert (error != null);
                                this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                                this.poolConfig.allocationStrategy().returnPermits(1);
                                borrower.fail(error);
                            }
                        }).contextWrite(borrower.currentContext());
                        if (permits == 1) {
                            primary.subscribe(alreadyPropagated -> {}, alreadyPropagatedOrLogged -> this.drain(), this::drain);
                        } else {
                            int toWarmup = permits - 1;
                            this.logger.debug("should warm up {} extra resources", toWarmup);
                            long startWarmupIteration = this.clock.millis();
                            int mergeConcurrency = Math.min(this.poolConfig.allocationStrategy().warmupParallelism(), toWarmup + 1);
                            Flux.range(1, toWarmup).map(i -> this.warmupMono((int)i, toWarmup, startWarmupIteration, allocator).doOnSuccess(__ -> this.drain())).startWith((Mono[])new Mono[]{primary.doOnSuccess(__ -> this.drain()).onErrorComplete().then()}).flatMap(Function.identity(), mergeConcurrency, 1).onErrorResume(e -> Mono.empty()).subscribe(aVoid -> {}, alreadyPropagatedOrLogged -> this.drain(), this::drain);
                        }
                    }
                }
            }
            if (WIP.decrementAndGet(this) == 0) break;
        }
        this.recordInteractionTimestamp();
    }

    private Mono<POOLABLE> allocatorWithScheduler() {
        Scheduler s = this.poolConfig.acquisitionScheduler();
        if (s != Schedulers.immediate()) {
            return this.poolConfig.allocator().publishOn(s);
        }
        return this.poolConfig.allocator();
    }

    Mono<Void> warmupMono(int index, int max, long startWarmupIteration, Mono<POOLABLE> allocator) {
        return allocator.flatMap(poolable -> {
            this.logger.debug("warmed up extra resource {}/{}", index, max);
            this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - startWarmupIteration);
            if (!this.elementOffer(poolable)) {
                QueuePooledRef<Object> tempRef = this.createSlot(poolable);
                tempRef.markDestroy();
                return this.destroyPoolable(tempRef);
            }
            return Mono.empty();
        }).onErrorResume(warmupError -> {
            this.logger.debug("failed to warm up extra resource {}/{}: {}", index, max, warmupError.toString());
            this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - startWarmupIteration);
            this.poolConfig.allocationStrategy().returnPermits(1);
            return Mono.empty();
        });
    }

    @Override
    public int pendingAcquireSize() {
        return this.pendingSize;
    }

    @Override
    boolean elementOffer(POOLABLE element) {
        Deque irq = IDLE_RESOURCES.get(this);
        if (irq == null) {
            return false;
        }
        if (irq.offer(this.createSlot(element))) {
            this.incrementIdle();
            return true;
        }
        return false;
    }

    final void maybeRecycleAndDrain(QueuePooledRef<POOLABLE> poolSlot, CoreSubscriber<? super Void> actual) {
        if (!this.isDisposed()) {
            this.recordInteractionTimestamp();
            if (!this.poolConfig.evictionPredicate().test(poolSlot.poolable, poolSlot)) {
                this.metricsRecorder.recordRecycled();
                Deque irq = IDLE_RESOURCES.get(this);
                if (irq != null) {
                    QueuePooledRef<POOLABLE> slot = this.recycleSlot(poolSlot);
                    boolean addedIdle = irq.offerLast(slot);
                    if (addedIdle) {
                        this.incrementIdle();
                    }
                    actual.onComplete();
                    this.drain();
                    if (this.isDisposed() && slot.markDestroy()) {
                        if (addedIdle) {
                            this.decrementIdle();
                        }
                        this.destroyPoolable(slot).subscribe();
                    }
                    return;
                }
            }
        }
        if (poolSlot.markDestroy()) {
            this.destroyPoolable(poolSlot).subscribe(null, e -> {
                actual.onError((Throwable)e);
                this.drain();
            }, () -> {
                actual.onComplete();
                this.drain();
            });
        } else {
            actual.onComplete();
        }
    }

    void pendingOffer(AbstractPool.Borrower<POOLABLE> pending) {
        int estimatePermitCount;
        int idle;
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> pendingQueue = this.pending;
        if (pendingQueue == TERMINATED) {
            return;
        }
        int postOffer = this.pendingSize;
        if (pendingQueue.offerLast(pending)) {
            postOffer = PENDING_SIZE.incrementAndGet(this);
        }
        if ((idle = this.idleSize) + (estimatePermitCount = this.poolConfig.allocationStrategy().estimatePermitCount()) < postOffer) {
            pending.pendingAcquireStart = this.clock.millis();
            if (!pending.pendingAcquireTimeout.isZero()) {
                pending.timeoutTask = this.config().pendingAcquireTimer().apply(pending, pending.pendingAcquireTimeout);
            }
        }
        if (WIP.getAndIncrement(this) == 0) {
            int maxPending = this.poolConfig.maxPending();
            if (maxPending >= 0 && postOffer > maxPending && this.idleSize == 0 && this.poolConfig.allocationStrategy().estimatePermitCount() == 0) {
                AbstractPool.Borrower<POOLABLE> toCull = pendingQueue.pollLast();
                if (toCull != null) {
                    PENDING_SIZE.decrementAndGet(this);
                    if (maxPending == 0) {
                        toCull.fail(new PoolAcquirePendingLimitException(0, "No pending allowed and pool has reached allocation limit"));
                    } else {
                        toCull.fail(new PoolAcquirePendingLimitException(maxPending));
                    }
                }
                if (WIP.decrementAndGet(this) > 0) {
                    this.drainLoop();
                }
                return;
            }
            this.drainLoop();
        }
    }

    @Nullable
    AbstractPool.Borrower<POOLABLE> pendingPoll(Deque<AbstractPool.Borrower<POOLABLE>> borrowers) {
        AbstractPool.Borrower<POOLABLE> b = borrowers.pollFirst();
        if (b != null) {
            PENDING_SIZE.decrementAndGet(this);
        }
        return b;
    }

    QueuePooledRef<POOLABLE> recycleSlot(QueuePooledRef<POOLABLE> slot) {
        return new QueuePooledRef<POOLABLE>(slot);
    }

    @Override
    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED || IDLE_RESOURCES.get(this) == null;
    }

    private static final class QueuePoolRecyclerMono<T>
    extends Mono<Void>
    implements Scannable {
        final Publisher<Void> source;
        final AtomicReference<QueuePooledRef<T>> slotRef;

        QueuePoolRecyclerMono(Publisher<Void> source, QueuePooledRef<T> poolSlot) {
            this.source = source;
            this.slotRef = new AtomicReference<QueuePooledRef<T>>(poolSlot);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.source;
            }
            return null;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> actual) {
            QueuePooledRef slot = this.slotRef.getAndSet(null);
            if (slot == null || !slot.markReleased()) {
                Operators.complete(actual);
            } else {
                QueuePoolRecyclerInner qpr = new QueuePoolRecyclerInner(actual, slot);
                this.source.subscribe(qpr);
            }
        }
    }

    private static final class QueuePoolRecyclerInner<T>
    implements CoreSubscriber<Void>,
    Scannable,
    Subscription {
        final CoreSubscriber<? super Void> actual;
        final SimpleDequePool<T> pool;
        QueuePooledRef<T> pooledRef;
        Subscription upstream;
        long start;
        volatile int once;
        static final AtomicIntegerFieldUpdater<QueuePoolRecyclerInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(QueuePoolRecyclerInner.class, "once");

        QueuePoolRecyclerInner(CoreSubscriber<? super Void> actual, QueuePooledRef<T> pooledRef) {
            this.actual = actual;
            this.pooledRef = Objects.requireNonNull(pooledRef, "pooledRef");
            this.pool = pooledRef.pool;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void onComplete() {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            this.pool.maybeRecycleAndDrain(slot, this.actual);
        }

        @Override
        public void onError(Throwable throwable) {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                Operators.onErrorDropped(throwable, this.actual.currentContext());
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            if (slot.markDestroy()) {
                this.pool.destroyPoolable(slot).subscribe(null, null, this.pool::drain);
            }
            this.actual.onError(throwable);
        }

        @Override
        public void onNext(Void o) {
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.upstream, s)) {
                this.start = this.pool.clock.millis();
                this.upstream = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void request(long l) {
            if (Operators.validate(l)) {
                this.upstream.request(l);
                if (ONCE.compareAndSet(this, 0, 1)) {
                    ACQUIRED.decrementAndGet(this.pool);
                }
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.upstream;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return false;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.pooledRef == null;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.pooledRef == null ? 0 : 1;
            }
            return null;
        }
    }

    static final class QueueBorrowerMono<T>
    extends Mono<PooledRef<T>> {
        final SimpleDequePool<T> parent;
        final Duration acquireTimeout;

        QueueBorrowerMono(SimpleDequePool<T> pool, Duration acquireTimeout) {
            this.parent = pool;
            this.acquireTimeout = acquireTimeout;
        }

        @Override
        public void subscribe(CoreSubscriber<? super PooledRef<T>> actual) {
            Objects.requireNonNull(actual, "subscribing with null");
            AbstractPool.Borrower<T> borrower = new AbstractPool.Borrower<T>(actual, this.parent, this.acquireTimeout);
            actual.onSubscribe(borrower);
        }
    }

    static final class QueuePooledRef<T>
    extends AbstractPool.AbstractPooledRef<T> {
        final SimpleDequePool<T> pool;

        QueuePooledRef(SimpleDequePool<T> pool, T poolable) {
            super(poolable, pool.metricsRecorder, pool.clock);
            this.pool = pool;
        }

        QueuePooledRef(QueuePooledRef<T> oldRef) {
            super(oldRef);
            this.pool = oldRef.pool;
        }

        @Override
        public Mono<Void> invalidate() {
            return Mono.defer(() -> {
                if (this.markSoftInvalidate()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    return this.pool.destroyPoolable(this).doFinally(st -> this.pool.drain());
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> release() {
            return Mono.defer(() -> {
                Publisher<Void> cleaner;
                if (STATE.get(this) == 2) {
                    return Mono.empty();
                }
                if (this.pool.isDisposed()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    if (this.markDestroy()) {
                        return this.pool.destroyPoolable(this);
                    }
                    return Mono.empty();
                }
                try {
                    cleaner = this.pool.poolConfig.releaseHandler().apply(this.poolable);
                }
                catch (Throwable releaseError) {
                    ACQUIRED.decrementAndGet(this.pool);
                    if (this.markDestroy()) {
                        return this.pool.destroyPoolable(this).onErrorResume(destroyError -> Mono.error(new IllegalStateException("Couldn't apply releaseHandler nor destroyHandler", Exceptions.multiple(releaseError, destroyError)))).then(Mono.error(new IllegalStateException("Couldn't apply releaseHandler, resource destroyed", releaseError))).doFinally(st -> this.pool.drain());
                    }
                    return Mono.error(new IllegalStateException("Couldn't apply releaseHandler", releaseError));
                }
                return new QueuePoolRecyclerMono(cleaner, this);
            });
        }
    }
}

