/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;

public class TrecDocumentGenerator {
    public TrecDocument summarize(File file) throws FileNotFoundException, IOException, TikaException {
        Tika tika = new Tika();
        Metadata met = new Metadata();
        String contents = tika.parseToString((InputStream)new FileInputStream(file), met);
        return new TrecDocument(met.get("resourceName"), contents, met.getDate(TikaCoreProperties.CREATED));
    }

    static class TrecDocument {
        private CharSequence docname;
        private CharSequence body;
        private Date date;

        public TrecDocument(CharSequence docname, CharSequence body, Date date) {
            this.docname = docname;
            this.body = body;
            this.date = date;
        }

        public TrecDocument() {
        }

        public CharSequence getDocname() {
            return this.docname;
        }

        public void setDocname(CharSequence docname) {
            this.docname = docname;
        }

        public CharSequence getBody() {
            return this.body;
        }

        public void setBody(CharSequence body) {
            this.body = body;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

