/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.StandardsExtractingContentHandler;
import org.xml.sax.ContentHandler;

public class StandardsExtractionExample {
    private static HashSet<String> standardReferences = new HashSet();
    private static int failedFiles = 0;
    private static int successfulFiles = 0;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: " + StandardsExtractionExample.class.getName() + " /path/to/input");
            System.exit(1);
        }
        String pathname = args[0];
        Path folder = Paths.get(pathname, new String[0]);
        System.out.println("Searching " + String.valueOf(folder.toAbsolutePath()) + "...");
        StandardsExtractionExample.processFolder(folder);
        System.out.println(standardReferences.toString());
        System.out.println("Parsed " + successfulFiles + "/" + (successfulFiles + failedFiles));
    }

    public static void processFolder(Path folder) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        StandardsExtractionExample.process(file);
                        ++successfulFiles;
                    }
                    catch (Exception e) {
                        ++failedFiles;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    ++failedFiles;
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void process(Path path) throws Exception {
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        StandardsExtractingContentHandler handler = new StandardsExtractingContentHandler((ContentHandler)new BodyContentHandler(-1), metadata);
        handler.setThreshold(0.75);
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String[] references = metadata.getValues("standard_references");
        Collections.addAll(standardReferences, references);
    }
}

