/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.net.URL;
import org.apache.tika.Tika;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.example.EncryptedPrescriptionDetector;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;

public class CustomMimeInfo {
    public static String customMimeInfo() throws Exception {
        String path = "file:///path/to/prescription-type.xml";
        MimeTypes typeDatabase = MimeTypesFactory.create((URL)new URL(path));
        Tika tika = new Tika((Detector)typeDatabase);
        return tika.detect("/path/to/prescription.xpd");
    }

    public static String customCompositeDetector() throws Exception {
        String path = "file:///path/to/prescription-type.xml";
        MimeTypes typeDatabase = MimeTypesFactory.create((URL)new URL(path));
        Tika tika = new Tika((Detector)new CompositeDetector(new Detector[]{typeDatabase, new EncryptedPrescriptionDetector()}));
        return tika.detect("/path/to/tmp/prescription.xpd");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("customMimeInfo=" + CustomMimeInfo.customMimeInfo());
        System.out.println("customCompositeDetector=" + CustomMimeInfo.customCompositeDetector());
    }
}

