/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.Link;
import org.apache.tika.sax.LinkContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RollbackSoftware {
    public static void main(String[] args) throws Exception {
        RollbackSoftware r = new RollbackSoftware();
        r.rollback(new File(args[0]));
    }

    public void rollback(File deployArea) throws IOException, SAXException, TikaException {
        LinkContentHandler handler = new LinkContentHandler();
        Metadata met = new Metadata();
        DeploymentAreaParser parser = new DeploymentAreaParser();
        parser.parse(IOUtils.toInputStream((String)deployArea.getAbsolutePath(), (Charset)StandardCharsets.UTF_8), (ContentHandler)handler, met);
        List links = handler.getLinks();
        if (links.size() < 2) {
            throw new IOException("Must have installed at least 2 versions!");
        }
        links.sort(Comparator.comparing(Link::getText));
        this.updateVersion(((Link)links.get(links.size() - 2)).getText());
    }

    private void updateVersion(String version) {
        System.out.println("Rolling back to version: [" + version + "]");
    }

    private boolean isSymlink(File f) throws IOException {
        return !f.getAbsolutePath().equals(f.getCanonicalPath());
    }

    class DeploymentAreaParser
    implements Parser {
        private static final long serialVersionUID = -2356647405087933468L;

        DeploymentAreaParser() {
        }

        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return Collections.unmodifiableSet(new HashSet<MediaType>(Collections.singletonList(MediaType.TEXT_PLAIN)));
        }

        public void parse(InputStream is, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
            this.parse(is, handler, metadata, new ParseContext());
        }

        public void parse(InputStream is, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            File deployArea = new File(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            File[] versions = deployArea.listFiles(pathname -> !pathname.getName().startsWith("current"));
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            for (File v : versions) {
                if (RollbackSoftware.this.isSymlink(v)) continue;
                xhtml.startElement("a", "href", v.toURI().toURL().toExternalForm());
                xhtml.characters(v.getName());
                xhtml.endElement("a");
            }
        }
    }
}

