/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.tika.Tika;

public class LuceneIndexer {
    private final Tika tika;
    private final IndexWriter writer;

    public LuceneIndexer(Tika tika, IndexWriter writer) {
        this.tika = tika;
        this.writer = writer;
    }

    public void indexDocument(File file) throws Exception {
        Document document = new Document();
        document.add((IndexableField)new TextField("filename", file.getName(), Field.Store.YES));
        document.add((IndexableField)new TextField("fulltext", this.tika.parseToString(file), Field.Store.NO));
        this.writer.addDocument((Iterable)document);
    }
}

