/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageHandler;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.language.detect.LanguageWriter;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;

public class Language {
    public static void languageDetection() throws IOException {
        LanguageDetector detector = new OptimaizeLangDetector().loadModels();
        LanguageResult result = detector.detect((CharSequence)"Alla m\u00e4nniskor \u00e4r f\u00f6dda fria och lika i v\u00e4rde och r\u00e4ttigheter.");
        System.out.println(result.getLanguage());
    }

    public static void languageDetectionWithWriter() throws IOException {
        LanguageDetector detector = new OptimaizeLangDetector().loadModels();
        try (LanguageWriter writer = new LanguageWriter(detector);){
            writer.append((CharSequence)"Minden emberi l\u00e9ny");
            writer.append((CharSequence)" szabadon sz\u00fcletik \u00e9s");
            writer.append((CharSequence)" egyenl\u0151 m\u00e9lt\u00f3s\u00e1ga \u00e9s");
            writer.append((CharSequence)" joga van.");
            LanguageResult result = writer.getLanguage();
            System.out.println(result.getLanguage());
        }
    }

    public static void languageDetectionWithHandler() throws Exception {
        LanguageHandler handler = new LanguageHandler();
        new AutoDetectParser().parse(System.in, (ContentHandler)handler, new Metadata(), new ParseContext());
        LanguageResult result = handler.getLanguage();
        System.out.println(result.getLanguage());
    }
}

