/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.config.TikaConfigSerializer;

public class DumpTikaConfigExample {
    public static void main(String[] args) throws Exception {
        Charset encoding = StandardCharsets.UTF_8;
        TikaConfigSerializer.Mode mode = TikaConfigSerializer.Mode.CURRENT;
        String filename = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (arg.contains("-dump-minimal")) {
                    mode = TikaConfigSerializer.Mode.MINIMAL;
                    continue;
                }
                if (arg.contains("-dump-current")) {
                    mode = TikaConfigSerializer.Mode.CURRENT;
                    continue;
                }
                if (arg.contains("-dump-static")) {
                    mode = TikaConfigSerializer.Mode.STATIC;
                    continue;
                }
                System.out.println("Use:");
                System.out.println("  DumpTikaConfig [--dump-minimal] [--dump-current] [--dump-static] [filename] [encoding]");
                System.out.println("");
                System.out.println("--dump-minimal    Produce the minimal config file");
                System.out.println("--dump-current    The current (with defaults) config file");
                System.out.println("--dump-static     Convert dynamic parts to static");
                return;
            }
            if (filename == null) {
                filename = arg;
                continue;
            }
            encoding = Charset.forName(arg);
        }
        Writer writer = null;
        writer = filename != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding) : new StringWriter();
        DumpTikaConfigExample ex = new DumpTikaConfigExample();
        TikaConfigSerializer.serialize((TikaConfig)TikaConfig.getDefaultConfig(), (TikaConfigSerializer.Mode)mode, (Writer)writer, (Charset)encoding);
        writer.flush();
        if (writer instanceof StringWriter) {
            System.out.println(writer.toString());
        }
        writer.close();
    }
}

