/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InterruptableParsingExample {
    private Tika tika = new Tika();

    public boolean findInFile(String query, Path path) {
        InterruptingContentHandler handler = new InterruptingContentHandler(query);
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)this.tika.getParser());
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            this.tika.getParser().parse((InputStream)is, (ContentHandler)handler, metadata, context);
        }
        catch (QueryMatchedException e) {
            return true;
        }
        catch (IOException | TikaException | SAXException e) {
            e.printStackTrace();
        }
        return false;
    }

    static class InterruptingContentHandler
    extends DefaultHandler {
        private String query;
        private StringBuilder sb = new StringBuilder();

        InterruptingContentHandler(String query) {
            this.query = query;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.sb.append(new String(ch, start, length).toLowerCase(Locale.getDefault()));
            if (this.sb.toString().contains(this.query)) {
                throw new QueryMatchedException();
            }
            if (this.sb.length() > 2 * this.query.length()) {
                this.sb.delete(0, this.sb.length() - this.query.length());
            }
        }
    }

    static class QueryMatchedException
    extends SAXException {
        QueryMatchedException() {
        }
    }
}

