/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExtractEmbeddedFiles {
    private Parser parser = new AutoDetectParser();
    private Detector detector = ((AutoDetectParser)this.parser).getDetector();
    private TikaConfig config = TikaConfig.getDefaultConfig();

    public void extract(InputStream is, Path outputDir) throws SAXException, TikaException, IOException {
        Metadata m = new Metadata();
        ParseContext c = new ParseContext();
        BodyContentHandler h = new BodyContentHandler(-1);
        c.set(Parser.class, (Object)this.parser);
        MyEmbeddedDocumentExtractor ex = new MyEmbeddedDocumentExtractor(outputDir, c);
        c.set(EmbeddedDocumentExtractor.class, (Object)ex);
        this.parser.parse(is, (ContentHandler)h, m, c);
    }

    private class MyEmbeddedDocumentExtractor
    extends ParsingEmbeddedDocumentExtractor {
        private final Path outputDir;
        private int fileCount;

        private MyEmbeddedDocumentExtractor(Path outputDir, ParseContext context) {
            super(context);
            this.fileCount = 0;
            this.outputDir = outputDir;
        }

        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            Path outputFile;
            Object name = metadata.get("resourceName");
            if (name == null) {
                name = "file_" + this.fileCount++;
            } else {
                int prefix = FilenameUtils.getPrefixLength((String)(name = ((String)name).replaceAll("\u0000", " ")));
                if (prefix > -1) {
                    name = ((String)name).substring(prefix);
                }
                name = FilenameUtils.normalize((String)FilenameUtils.getName((String)name));
            }
            MediaType contentType = ExtractEmbeddedFiles.this.detector.detect(stream, metadata);
            if (((String)name).indexOf(46) == -1 && contentType != null) {
                try {
                    name = (String)name + ExtractEmbeddedFiles.this.config.getMimeRepository().forName(contentType.toString()).getExtension();
                }
                catch (MimeTypeException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(outputFile = this.outputDir.resolve((String)name), new LinkOption[0])) {
                outputFile = this.outputDir.resolve(UUID.randomUUID().toString() + "-" + (String)name);
            }
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            Files.copy(stream, outputFile, new CopyOption[0]);
        }
    }
}

