/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.html.IdentityHtmlMapper;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.LinkContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TIAParsingExample {
    public static String parseToStringExample() throws Exception {
        File document = new File("example.doc");
        String content = new Tika().parseToString(document);
        System.out.print(content);
        return content;
    }

    public static void parseToReaderExample() throws Exception {
        File document = new File("example.doc");
        try (Reader reader = new Tika().parse(document);){
            char[] buffer = new char[1000];
            int n = reader.read(buffer);
            while (n != -1) {
                System.out.append(CharBuffer.wrap(buffer, 0, n));
                n = reader.read(buffer);
            }
        }
    }

    public static void parseFileInputStream(String filename) throws Exception {
        AutoDetectParser parser = new AutoDetectParser();
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (FileInputStream stream = new FileInputStream(new File(filename));){
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
    }

    public static void parseURLStream(String address) throws Exception {
        AutoDetectParser parser = new AutoDetectParser();
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (GZIPInputStream stream = new GZIPInputStream(new URL(address).openStream());){
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
    }

    public static void parseTikaInputStream(String filename) throws Exception {
        AutoDetectParser parser = new AutoDetectParser();
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (TikaInputStream stream = TikaInputStream.get((Path)Paths.get(filename, new String[0]));){
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
    }

    public static File tikaInputStreamGetFile(String filename) throws Exception {
        try (TikaInputStream stream = TikaInputStream.get((Path)Paths.get(filename, new String[0]));){
            TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)stream);
            File file = tikaInputStream.getFile();
            return file;
        }
    }

    public static void useHtmlParser() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        HtmlParser parser = new HtmlParser();
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }

    public static void useCompositeParser() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        ParseContext context = new ParseContext();
        HashMap<MediaType, Object> parsersByType = new HashMap<MediaType, Object>();
        parsersByType.put(MediaType.parse((String)"text/html"), new HtmlParser());
        parsersByType.put(MediaType.parse((String)"application/xml"), new XMLParser());
        CompositeParser parser = new CompositeParser();
        parser.setParsers(parsersByType);
        parser.setFallback((Parser)new TXTParser());
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "text/html");
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }

    public static void useAutoDetectParser() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        AutoDetectParser parser = new AutoDetectParser();
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }

    public static void testTeeContentHandler(String filename) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        AutoDetectParser parser = new AutoDetectParser();
        LinkContentHandler linkCollector = new LinkContentHandler();
        try (FileOutputStream output = new FileOutputStream(new File(filename));){
            TeeContentHandler handler = new TeeContentHandler(new ContentHandler[]{new BodyContentHandler((OutputStream)output), linkCollector});
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
    }

    public static void testLocale() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.ENGLISH);
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }

    public static void testHtmlMapper() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        ParseContext context = new ParseContext();
        context.set(HtmlMapper.class, (Object)new IdentityHtmlMapper());
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }

    public static void testCompositeDocument() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        AutoDetectParser parser = new AutoDetectParser();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)new ParserDecorator((Parser)parser){
            private static final long serialVersionUID = 4424210691523343833L;

            public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            }
        });
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
    }
}

