/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.util.Map;
import java.util.SortedSet;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class MediaTypeExample {
    public static void describeMediaType() {
        MediaType type = MediaType.parse((String)"text/plain; charset=UTF-8");
        System.out.println("type:    " + type.getType());
        System.out.println("subtype: " + type.getSubtype());
        Map parameters = type.getParameters();
        System.out.println("parameters:");
        for (String name : parameters.keySet()) {
            System.out.println("  " + name + "=" + (String)parameters.get(name));
        }
    }

    public static void listAllTypes() {
        MediaTypeRegistry registry = MediaTypeRegistry.getDefaultRegistry();
        for (MediaType type : registry.getTypes()) {
            SortedSet aliases = registry.getAliases(type);
            System.out.println(type + ", also known as " + aliases);
        }
    }

    public static void main(String[] args) throws Exception {
        MediaTypeRegistry registry = MediaTypeRegistry.getDefaultRegistry();
        MediaType type = MediaType.parse((String)"image/svg+xml");
        while (type != null) {
            System.out.println(type);
            type = registry.getSupertype(type);
        }
    }
}

