/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.serialization.JsonMetadata;

public class JsonStreamingSerializer
implements AutoCloseable {
    private final Writer writer;
    boolean hasStartedArray = false;
    private JsonGenerator jsonGenerator;

    public JsonStreamingSerializer(Writer writer) {
        this.writer = writer;
    }

    public void add(Metadata metadata) throws IOException {
        if (!this.hasStartedArray) {
            this.jsonGenerator = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createGenerator(this.writer);
            this.jsonGenerator.writeStartArray();
            this.hasStartedArray = true;
        }
        Object[] names = metadata.names();
        Arrays.sort(names);
        JsonMetadata.writeMetadataObject(metadata, this.jsonGenerator, false);
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
    }
}

