/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TrainTestSplit {
    private static String TRAINING = "train";
    private static String TESTING = "test";
    private static String DEVTEST = "devtest";
    private float trainingP = 0.7f;
    private float devTestP = 0.1f;
    private float testP = 0.2f;
    private Random random = new Random();

    public static void main(String[] args) throws Exception {
        Path leipzigDir = Paths.get(args[0], new String[0]);
        Path outputDir = Paths.get(args[1], new String[0]);
        TrainTestSplit splitter = new TrainTestSplit();
        splitter.execute(leipzigDir, outputDir);
    }

    private void execute(Path leipzigDir, Path outputDir) throws Exception {
        this.initOutDirs(outputDir);
        for (File f : leipzigDir.toFile().listFiles()) {
            if (f.isDirectory()) continue;
            this.processFile(f, outputDir);
        }
    }

    private void initOutDirs(Path outputDir) throws Exception {
        for (String which : new String[]{TRAINING, DEVTEST, TESTING}) {
            Path target = outputDir.resolve(which);
            if (Files.isDirectory(target, new LinkOption[0])) continue;
            Files.createDirectories(target, new FileAttribute[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processFile(File f, Path outputDir) throws Exception {
        Map<String, BufferedWriter> writers = this.getWriters(outputDir, f);
        System.err.println("working on " + f);
        try (BufferedReader reader = Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);){
            void var5_6;
            String string = reader.readLine();
            while (var5_6 != null) {
                float r = this.random.nextFloat();
                if (r <= this.trainingP) {
                    writers.get(TRAINING).write((String)var5_6 + "\n");
                } else if (r < this.trainingP + this.devTestP) {
                    writers.get(DEVTEST).write((String)var5_6 + "\n");
                } else {
                    writers.get(TESTING).write((String)var5_6 + "\n");
                }
                String string2 = reader.readLine();
            }
        }
        for (Writer writer : writers.values()) {
            writer.flush();
            writer.close();
        }
    }

    private Map<String, BufferedWriter> getWriters(Path outputDir, File f) throws IOException {
        HashMap<String, BufferedWriter> writers = new HashMap<String, BufferedWriter>();
        for (String which : new String[]{TRAINING, DEVTEST, TESTING}) {
            writers.put(which, this.getWriter(outputDir, which, f));
        }
        return writers;
    }

    private BufferedWriter getWriter(Path outputDir, String which, File f) throws IOException {
        GzipCompressorOutputStream os = new GzipCompressorOutputStream(new BufferedOutputStream(Files.newOutputStream(outputDir.resolve(which).resolve(f.getName() + ".gz"), new OpenOption[0])));
        return new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
    }
}

