/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;

public final class SlowCompositeReaderWrapper
extends LeafReader {
    final Map<String, Terms> cachedTerms = new ConcurrentHashMap<String, Terms>();
    final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();
    private final CompositeReader in;
    private final LeafMetaData metaData;
    private final FieldInfos fieldInfos;

    SlowCompositeReaderWrapper(CompositeReader reader) throws IOException {
        this.in = reader;
        this.in.registerParentReader(this);
        if (reader.leaves().isEmpty()) {
            this.metaData = new LeafMetaData(Version.LATEST.major, Version.LATEST, null, false);
        } else {
            Version minVersion = Version.LATEST;
            for (LeafReaderContext leafReaderContext : reader.leaves()) {
                Version leafVersion = leafReaderContext.reader().getMetaData().getMinVersion();
                if (leafVersion == null) {
                    minVersion = null;
                    break;
                }
                if (!minVersion.onOrAfter(leafVersion)) continue;
                minVersion = leafVersion;
            }
            this.metaData = new LeafMetaData(reader.leaves().get(0).reader().getMetaData().getCreatedVersionMajor(), minVersion, null, false);
        }
        this.fieldInfos = FieldInfos.getMergedFieldInfos(this.in);
    }

    public static LeafReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader);
        }
        assert (reader instanceof LeafReader);
        return (LeafReader)reader;
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        try {
            return this.cachedTerms.computeIfAbsent(field, f -> {
                try {
                    return MultiTerms.getTerms(this.in, f);
                }
                catch (IOException e) {
                    throw new RuntimeException("unwrapMe", e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("unwrapMe") && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues(this.in, field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues(this.in, field);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues(this.in, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedDocValues dv = MultiDocValues.getSortedValues(this.in, field);
                if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                    map = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        int size = this.in.leaves().size();
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED) {
                return null;
            }
            SortedDocValues v = reader.getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedDocValues(values, starts, map, totalCost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(field);
            if (map == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues(this.in, field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMaps.put(field, map);
                    }
                }
                return dv;
            }
        }
        assert (map != null);
        int size = this.in.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long cost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
            cost += v.cost();
        }
        starts[size] = this.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, cost);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues(this.in, field);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String s) throws IOException {
        return null;
    }

    @Override
    public ByteVectorValues getByteVectorValues(String s) throws IOException {
        return null;
    }

    @Override
    public void searchNearestVectors(String string, float[] floats, KnnCollector kc, Bits bits) throws IOException {
    }

    @Override
    public void searchNearestVectors(String string, byte[] bytes, KnnCollector kc, Bits bits) throws IOException {
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        return this.in.termVectors().get(docID);
    }

    @Override
    public TermVectors termVectors() throws IOException {
        return this.in.termVectors();
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.storedFields().document(docID, visitor);
    }

    @Override
    public StoredFields storedFields() throws IOException {
        return this.in.storedFields();
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return MultiBits.getLiveDocs(this.in);
    }

    @Override
    public PointValues getPointValues(String field) {
        this.ensureOpen();
        return null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.metaData;
    }
}

