/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.db;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class AbstractDBBuffer {
    private final Map<String, Integer> m = new HashMap<String, Integer>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private int numWrites = 0;

    AbstractDBBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(String key) {
        Integer v;
        this.r.lock();
        try {
            v = this.m.get(key);
            if (v != null) {
                int n = v;
                return n;
            }
        }
        finally {
            this.r.unlock();
        }
        try {
            this.w.lock();
            v = this.m.get(key);
            if (v != null) {
                int n = v;
                return n;
            }
            v = this.m.size() + 1;
            this.m.put(key, v);
            this.write(v, key);
            ++this.numWrites;
            int n = v;
            return n;
        }
        finally {
            this.w.unlock();
        }
    }

    public int getNumWrites() {
        return this.numWrites;
    }

    public abstract void write(int var1, String var2) throws RuntimeException;

    public abstract void close() throws SQLException;
}

