/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.transport.AddressUtils;

final class DefaultHttpForwardedHeaderHandler
implements BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> {
    static final DefaultHttpForwardedHeaderHandler INSTANCE = new DefaultHttpForwardedHeaderHandler();
    static final String FORWARDED_HEADER = "Forwarded";
    static final String X_FORWARDED_IP_HEADER = "X-Forwarded-For";
    static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([a-zA-Z][a-zA-Z0-9+.-]*)\"?");
    static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    static final Pattern X_FORWARDED_PROTO_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*$");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @Deprecated
    static final String FORWARDED_HEADER_VALIDATION = "reactor.netty.http.server.forwarded.strictValidation";
    static final boolean DEFAULT_FORWARDED_HEADER_VALIDATION = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.forwarded.strictValidation", "true"));

    DefaultHttpForwardedHeaderHandler() {
    }

    @Override
    public ConnectionInfo apply(ConnectionInfo connectionInfo, HttpRequest request) {
        String forwardedHeader = request.headers().get(FORWARDED_HEADER);
        if (forwardedHeader != null) {
            return DefaultHttpForwardedHeaderHandler.parseForwardedInfo(connectionInfo, forwardedHeader);
        }
        return DefaultHttpForwardedHeaderHandler.parseXForwardedInfo(connectionInfo, request);
    }

    private static ConnectionInfo parseForwardedInfo(ConnectionInfo connectionInfo, String forwardedHeader) {
        Matcher forMatcher;
        Matcher hostMatcher;
        String forwarded = forwardedHeader.split(",", 2)[0];
        Matcher protoMatcher = FORWARDED_PROTO_PATTERN.matcher(forwarded);
        if (protoMatcher.find()) {
            connectionInfo = connectionInfo.withScheme(protoMatcher.group(1).trim());
        }
        if ((hostMatcher = FORWARDED_HOST_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withHostAddress(AddressUtils.parseAddress(hostMatcher.group(1), ConnectionInfo.getDefaultHostPort(connectionInfo.getScheme()), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        if ((forMatcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withRemoteAddress(AddressUtils.parseAddress(forMatcher.group(1).trim(), connectionInfo.getRemoteAddress().getPort(), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        return connectionInfo;
    }

    private static ConnectionInfo parseXForwardedInfo(ConnectionInfo connectionInfo, HttpRequest request) {
        String prefixHeader;
        String portHeader;
        String hostHeader;
        String protoStr;
        String protoHeader;
        String ipHeader = request.headers().get(X_FORWARDED_IP_HEADER);
        if (ipHeader != null) {
            connectionInfo = connectionInfo.withRemoteAddress(AddressUtils.parseAddress(ipHeader.split(",", 2)[0], connectionInfo.getRemoteAddress().getPort()));
        }
        if ((protoHeader = request.headers().get(X_FORWARDED_PROTO_HEADER)) != null && X_FORWARDED_PROTO_PATTERN.matcher(protoStr = protoHeader.split(",", 2)[0].trim()).matches()) {
            connectionInfo = connectionInfo.withScheme(protoStr);
        }
        if ((hostHeader = request.headers().get(X_FORWARDED_HOST_HEADER)) != null) {
            connectionInfo = connectionInfo.withHostAddress(AddressUtils.parseAddress(hostHeader.split(",", 2)[0].trim(), ConnectionInfo.getDefaultHostPort(connectionInfo.getScheme()), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        if ((portHeader = request.headers().get(X_FORWARDED_PORT_HEADER)) != null && !portHeader.isEmpty()) {
            String portStr = portHeader.split(",", 2)[0].trim();
            if (portStr.chars().allMatch(Character::isDigit)) {
                int port = Integer.parseInt(portStr);
                connectionInfo = connectionInfo.withHostAddress(AddressUtils.createUnresolved(connectionInfo.getHostAddress().getHostString(), port), connectionInfo.getHostName(), port);
            } else if (DEFAULT_FORWARDED_HEADER_VALIDATION) {
                throw new IllegalArgumentException("Failed to parse a port from " + portHeader);
            }
        }
        if ((prefixHeader = request.headers().get(X_FORWARDED_PREFIX_HEADER)) != null) {
            connectionInfo = connectionInfo.withForwardedPrefix(DefaultHttpForwardedHeaderHandler.parseForwardedPrefix(prefixHeader));
        }
        return connectionInfo;
    }

    private static String parseForwardedPrefix(String prefixHeader) {
        String[] rawPrefixes;
        StringBuilder prefix = new StringBuilder(prefixHeader.length());
        for (String rawPrefix : rawPrefixes = DefaultHttpForwardedHeaderHandler.tokenizeToStringArray(prefixHeader)) {
            int endIndex;
            for (endIndex = rawPrefix.length(); endIndex > 1 && rawPrefix.charAt(endIndex - 1) == '/'; --endIndex) {
            }
            prefix.append(endIndex != rawPrefix.length() ? rawPrefix.substring(0, endIndex) : rawPrefix);
        }
        String parsedPrefix = prefix.toString();
        if (!parsedPrefix.isEmpty() && DEFAULT_FORWARDED_HEADER_VALIDATION && parsedPrefix.charAt(0) != '/') {
            throw new IllegalArgumentException("X-Forwarded-Prefix did not start with a slash (\"/\"): " + prefixHeader);
        }
        return parsedPrefix;
    }

    private static String[] tokenizeToStringArray(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            tokens.add(token);
        }
        return !tokens.isEmpty() ? tokens.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }
}

