/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.AsciiString;
import io.netty.util.NetUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.WebsocketClientOperations;
import reactor.netty.http.client.WebsocketClientSpec;

final class Http2WebsocketClientOperations
extends WebsocketClientOperations {
    WebsocketClientHandshaker handshakerHttp2;

    Http2WebsocketClientOperations(URI currentURI, WebsocketClientSpec websocketClientSpec, HttpClientOperations replaced) {
        super(currentURI, websocketClientSpec, replaced);
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            HttpResponseStatus status = response.status();
            response.content().release();
            String errorMsg = !HttpResponseStatus.OK.equals(status) ? "Invalid websocket handshake response status [" + status + "]." : "Failed to upgrade to websocket. End of stream is received.";
            this.onInboundError(new WebSocketClientHandshakeException(errorMsg, response));
            ctx.close();
        } else if (msg instanceof HttpResponse) {
            this.started = true;
            HttpResponse response = (HttpResponse)msg;
            this.setNettyResponse(response);
            if (this.notRedirected(response)) {
                try {
                    HttpResponseStatus status = response.status();
                    if (!HttpResponseStatus.OK.equals(status)) {
                        throw new WebSocketClientHandshakeException("Invalid websocket handshake response status [" + status + "].", response);
                    }
                    this.handshakerHttp2.finishHandshake(this.channel(), response);
                    ctx.read();
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ctx.close();
                }
            } else {
                this.listener().onUncaughtException(this, this.redirecting);
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    public @Nullable String selectedSubprotocol() {
        return this.handshakerHttp2.actualSubProtocol;
    }

    @Override
    void initHandshaker(URI currentURI, WebsocketClientSpec websocketClientSpec) {
        String subProtocols;
        if (websocketClientSpec.version() != WebSocketVersion.V13) {
            throw new WebSocketClientHandshakeException("Websocket version [" + websocketClientSpec.version().toHttpHeaderValue() + "] is not supported.");
        }
        this.removeHandler("reactor.left.httpMetricsHandler");
        if (websocketClientSpec.compress()) {
            this.requestHeaders().remove(HttpHeaderNames.ACCEPT_ENCODING);
            this.removeHandler("reactor.left.httpDecompressor");
            PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker = new PerMessageDeflateClientExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketClientSpec.compressionAllowClientNoContext(), websocketClientSpec.compressionRequestedServerNoContext(), 0);
            this.addHandlerFirst("reactor.left.wsCompressionHandler", new WebsocketClientExtensionHandler(Arrays.asList(perMessageDeflateClientExtensionHandshaker, new DeflateFrameClientExtensionHandshaker(6, false, 0), new DeflateFrameClientExtensionHandshaker(6, true, 0))));
        }
        this.handshakerHttp2 = new WebsocketClientHandshaker(currentURI, (subProtocols = websocketClientSpec.protocols()) != null && !subProtocols.isEmpty() ? subProtocols : null, this.requestHeaders().remove(HttpHeaderNames.HOST), websocketClientSpec.maxFramePayloadLength());
        Channel channel = this.channel();
        this.handshakerHttp2.handshake(channel).addListener(f -> {
            this.markPersistent(false);
            channel.read();
        });
    }

    @Override
    boolean isHandshakeComplete() {
        return this.handshakerHttp2.handshakeComplete;
    }

    @Override
    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().write(frame);
            this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            frame.release();
        }
    }

    static final class WebsocketClientHandshaker {
        static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
        static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
        static final AsciiString V13 = AsciiString.cached("13");
        final HttpHeaders customHeaders;
        final @Nullable String expectedSubProtocol;
        final int maxFramePayloadLength;
        final URI uri;
        volatile @Nullable String actualSubProtocol;
        volatile boolean handshakeComplete;

        WebsocketClientHandshaker(URI uri, @Nullable String subProtocol, HttpHeaders customHeaders, int maxFramePayloadLength) {
            this.uri = uri;
            this.expectedSubProtocol = subProtocol;
            this.customHeaders = customHeaders;
            this.maxFramePayloadLength = maxFramePayloadLength;
        }

        void finishHandshake(Channel channel, HttpResponse response) {
            String receivedProtocol = response.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
            receivedProtocol = receivedProtocol != null ? receivedProtocol.trim() : null;
            String expectedProtocol = this.expectedSubProtocol != null ? this.expectedSubProtocol : "";
            boolean protocolValid = false;
            if (expectedProtocol.isEmpty() && receivedProtocol == null) {
                protocolValid = true;
                this.actualSubProtocol = this.expectedSubProtocol;
            } else if (!expectedProtocol.isEmpty() && receivedProtocol != null && !receivedProtocol.isEmpty()) {
                for (String protocol : expectedProtocol.split(",")) {
                    if (!protocol.trim().equals(receivedProtocol)) continue;
                    protocolValid = true;
                    this.actualSubProtocol = receivedProtocol;
                    break;
                }
            }
            if (!protocolValid) {
                throw new WebSocketClientHandshakeException("Invalid subprotocol. Actual [" + receivedProtocol + "]. Expected one of [" + this.expectedSubProtocol + "]", response);
            }
            this.handshakeComplete = true;
            ChannelPipeline p = channel.pipeline();
            ChannelHandlerContext ctx = p.context("ws-encoder");
            if (ctx == null) {
                throw new WebSocketClientHandshakeException("ChannelPipeline does not contain an ws-encoder", response);
            }
            p.addAfter(ctx.name(), "ws-decoder", WebsocketClientHandshaker.newWebsocketDecoder(this.maxFramePayloadLength));
        }

        ChannelFuture handshake(Channel channel) {
            ChannelPromise promise = channel.newPromise();
            ChannelPipeline pipeline = channel.pipeline();
            ChannelHandlerContext codec = pipeline.context("reactor.left.h2ToHttp11Codec");
            if (codec == null) {
                promise.setFailure(new WebSocketClientHandshakeException("ChannelPipeline does not contain an Http2StreamFrameToHttpObjectCodec"));
                return promise;
            }
            pipeline.addBefore(codec.name(), "reactor.left.protocolHeaderHandler", ProtocolHeaderHandler.INSTANCE);
            HttpRequest request = this.newHandshakeRequest();
            channel.writeAndFlush(request).addListener(future -> {
                if (future.isSuccess()) {
                    ChannelPipeline p = future.channel().pipeline();
                    ChannelHandlerContext ctx = p.context("reactor.left.httpTrafficHandler");
                    if (ctx == null) {
                        promise.setFailure(new WebSocketClientHandshakeException("ChannelPipeline does not contain an Http2StreamBridgeClientHandler"));
                        return;
                    }
                    p.addAfter(ctx.name(), "ws-encoder", WebsocketClientHandshaker.newWebsocketEncoder());
                    p.replace(ctx.name(), "reactor.left.websocketStreamBridgeClientHandler", (ChannelHandler)WebsocketStreamBridgeClientHandler.INSTANCE);
                    promise.setSuccess();
                } else {
                    promise.setFailure(future.cause());
                }
            });
            return promise;
        }

        HttpRequest newHandshakeRequest() {
            DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, WebsocketClientHandshaker.upgradeUrl(this.uri));
            HttpHeaders headers = request.headers();
            headers.add(this.customHeaders);
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)WebsocketClientHandshaker.websocketHostValue(this.uri));
            if (!headers.contains(HttpHeaderNames.ORIGIN)) {
                headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)WebsocketClientHandshaker.websocketOriginValue(this.uri));
            }
            if (this.expectedSubProtocol != null && !this.expectedSubProtocol.isEmpty()) {
                headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)this.expectedSubProtocol);
            }
            headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)V13);
            return request;
        }

        static ChannelHandler newWebsocketDecoder(int maxFramePayloadLength) {
            return new WebSocket13FrameDecoder(false, true, maxFramePayloadLength, false);
        }

        static ChannelHandler newWebsocketEncoder() {
            return new WebSocket13FrameEncoder(true);
        }

        static String upgradeUrl(URI wsURL) {
            String path = wsURL.getRawPath();
            path = path == null || path.isEmpty() ? "/" : path;
            String query = wsURL.getRawQuery();
            return query != null && !query.isEmpty() ? path + '?' + query : path;
        }

        static CharSequence websocketHostValue(URI wsURL) {
            int port = wsURL.getPort();
            if (port == -1) {
                return wsURL.getHost();
            }
            String host = wsURL.getHost();
            String scheme = wsURL.getScheme();
            if (port == HttpScheme.HTTP.port()) {
                return HttpScheme.HTTP.name().contentEquals(scheme) || WebSocketScheme.WS.name().contentEquals(scheme) ? host : NetUtil.toSocketAddressString(host, port);
            }
            if (port == HttpScheme.HTTPS.port()) {
                return HttpScheme.HTTPS.name().contentEquals(scheme) || WebSocketScheme.WSS.name().contentEquals(scheme) ? host : NetUtil.toSocketAddressString(host, port);
            }
            return NetUtil.toSocketAddressString(host, port);
        }

        static CharSequence websocketOriginValue(URI wsURL) {
            int defaultPort;
            String schemePrefix;
            String scheme = wsURL.getScheme();
            int port = wsURL.getPort();
            if (WebSocketScheme.WSS.name().contentEquals(scheme) || HttpScheme.HTTPS.name().contentEquals(scheme) || scheme == null && port == WebSocketScheme.WSS.port()) {
                schemePrefix = HTTPS_SCHEME_PREFIX;
                defaultPort = WebSocketScheme.WSS.port();
            } else {
                schemePrefix = HTTP_SCHEME_PREFIX;
                defaultPort = WebSocketScheme.WS.port();
            }
            String host = wsURL.getHost().toLowerCase(Locale.US);
            if (port != defaultPort && port != -1) {
                return schemePrefix + NetUtil.toSocketAddressString(host, port);
            }
            return schemePrefix + host;
        }

        static final class WebsocketStreamBridgeClientHandler
        extends ChannelDuplexHandler {
            static final WebsocketStreamBridgeClientHandler INSTANCE = new WebsocketStreamBridgeClientHandler();
            static final String NAME = "reactor.left.websocketStreamBridgeClientHandler";

            WebsocketStreamBridgeClientHandler() {
            }

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (!(msg instanceof FullHttpResponse) && msg instanceof HttpContent) {
                    ctx.fireChannelRead(((HttpContent)msg).content());
                } else {
                    ctx.fireChannelRead(msg);
                }
            }

            @Override
            public boolean isSharable() {
                return true;
            }

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof ByteBuf) {
                    ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
                } else {
                    ctx.write(msg, promise);
                }
            }
        }

        static final class ProtocolHeaderHandler
        extends ChannelOutboundHandlerAdapter {
            static final ProtocolHeaderHandler INSTANCE = new ProtocolHeaderHandler();
            static final String NAME = "reactor.left.protocolHeaderHandler";

            ProtocolHeaderHandler() {
            }

            @Override
            public boolean isSharable() {
                return true;
            }

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof Http2HeadersFrame) {
                    ((Http2HeadersFrame)msg).headers().set(Http2Headers.PseudoHeaderName.PROTOCOL.value(), HttpHeaderValues.WEBSOCKET);
                    ctx.pipeline().remove(this);
                }
                ctx.write(msg, promise);
            }
        }
    }

    static final class WebsocketClientExtensionHandler
    extends ChannelDuplexHandler {
        final List<WebSocketClientExtensionHandshaker> extensionHandshakers;
        static final String EXTENSION_SEPARATOR = ",";
        static final String PARAMETER_SEPARATOR = ";";
        static final char PARAMETER_EQUAL = '=';

        WebsocketClientExtensionHandler(List<WebSocketClientExtensionHandshaker> extensionHandshakers) {
            this.extensionHandshakers = extensionHandshakers;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                if (msg.getClass() == DefaultHttpResponse.class) {
                    this.onHttpResponseChannelRead(ctx, (DefaultHttpResponse)msg);
                } else if (msg instanceof HttpResponse && !(msg instanceof FullHttpResponse)) {
                    this.onHttpResponseChannelRead(ctx, (HttpResponse)msg);
                } else {
                    ctx.fireChannelRead(msg);
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg != Unpooled.EMPTY_BUFFER && !(msg instanceof ByteBuf)) {
                if (msg.getClass() == DefaultHttpRequest.class) {
                    this.onHttpRequestWrite(ctx, (DefaultHttpRequest)msg, promise);
                } else if (msg instanceof HttpRequest) {
                    this.onHttpRequestWrite(ctx, (HttpRequest)msg, promise);
                } else {
                    ctx.write(msg, promise);
                }
            } else {
                ctx.write(msg, promise);
            }
        }

        void onHttpRequestWrite(ChannelHandlerContext ctx, HttpRequest request, ChannelPromise promise) {
            String headerValue = request.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker extensionHandshaker : this.extensionHandshakers) {
                extraExtensions.add(extensionHandshaker.newRequestData());
            }
            String newHeaderValue = WebsocketClientExtensionHandler.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
            request.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
            ctx.write(request, promise);
        }

        void onHttpResponseChannelRead(ChannelHandlerContext ctx, HttpResponse response) {
            if (HttpResponseStatus.OK.equals(response.status())) {
                String extensionsHeader = response.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                if (extensionsHeader != null) {
                    List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
                    ArrayList<WebSocketExtension> validExtensions = new ArrayList<WebSocketExtension>(extensions.size());
                    int rsv = 0;
                    for (WebSocketExtensionData webSocketExtensionData : extensions) {
                        Iterator<WebSocketClientExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                        WebSocketExtension validExtension = null;
                        while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                            WebSocketClientExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                            validExtension = extensionHandshaker.handshakeExtension(webSocketExtensionData);
                        }
                        if (validExtension != null && (validExtension.rsv() & rsv) == 0) {
                            rsv |= validExtension.rsv();
                            validExtensions.add(validExtension);
                            continue;
                        }
                        throw new CodecException("invalid Websocket Extension handshake for [" + extensionsHeader + ']');
                    }
                    for (WebSocketClientExtension webSocketClientExtension : validExtensions) {
                        WebSocketExtensionDecoder decoder = webSocketClientExtension.newExtensionDecoder();
                        WebSocketExtensionEncoder encoder = webSocketClientExtension.newExtensionEncoder();
                        ctx.pipeline().addAfter(ctx.name(), decoder.getClass().getName(), decoder);
                        ctx.pipeline().addAfter(ctx.name(), encoder.getClass().getName(), encoder);
                    }
                }
                ctx.pipeline().remove(ctx.name());
            }
            ctx.fireChannelRead(response);
        }

        static String computeMergeExtensionsHeaderValue(@Nullable String userDefinedHeaderValue, List<WebSocketExtensionData> extraExtensions) {
            List<Object> userDefinedExtensions = userDefinedHeaderValue != null ? WebSocketExtensionUtil.extractExtensions(userDefinedHeaderValue) : Collections.emptyList();
            for (WebSocketExtensionData webSocketExtensionData : userDefinedExtensions) {
                int i;
                WebSocketExtensionData matchingExtra = null;
                for (i = 0; i < extraExtensions.size(); ++i) {
                    WebSocketExtensionData extra = extraExtensions.get(i);
                    if (!extra.name().equals(webSocketExtensionData.name())) continue;
                    matchingExtra = extra;
                    break;
                }
                if (matchingExtra == null) {
                    extraExtensions.add(webSocketExtensionData);
                    continue;
                }
                HashMap<String, String> mergedParameters = new HashMap<String, String>(matchingExtra.parameters());
                mergedParameters.putAll(webSocketExtensionData.parameters());
                extraExtensions.set(i, new WebSocketExtensionData(matchingExtra.name(), mergedParameters));
            }
            StringBuilder sb = new StringBuilder(150);
            for (WebSocketExtensionData data : extraExtensions) {
                sb.append(data.name());
                for (Map.Entry<String, String> parameter : data.parameters().entrySet()) {
                    sb.append(PARAMETER_SEPARATOR);
                    sb.append(parameter.getKey());
                    if (parameter.getValue() == null) continue;
                    sb.append('=');
                    sb.append(parameter.getValue());
                }
                sb.append(EXTENSION_SEPARATOR);
            }
            if (!extraExtensions.isEmpty()) {
                sb.setLength(sb.length() - EXTENSION_SEPARATOR.length());
            }
            return sb.toString();
        }
    }
}

