/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.Transport;
import reactor.netty.udp.UdpInbound;
import reactor.netty.udp.UdpOutbound;
import reactor.netty.udp.UdpServerBind;
import reactor.netty.udp.UdpServerConfig;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class UdpServer
extends Transport<UdpServer, UdpServerConfig> {
    static final Logger log = Loggers.getLogger(UdpServer.class);

    public static UdpServer create() {
        return UdpServerBind.INSTANCE;
    }

    @Override
    public final <A> UdpServer attr(AttributeKey<A> key, @Nullable A value) {
        return (UdpServer)super.attr(key, value);
    }

    public abstract Mono<? extends Connection> bind();

    @Override
    public final UdpServer bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (UdpServer)super.bindAddress(bindAddressSupplier);
    }

    public final Connection bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final Connection bindNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull(this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.contains("blocking read")) {
                throw new IllegalStateException("UdpServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final UdpServer doOnBind(Consumer<? super UdpServerConfig> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super UdpServerConfig> current = ((UdpServerConfig)dup.configuration()).doOnBind;
        ((UdpServerConfig)dup.configuration()).doOnBind = current == null ? doOnBind : current.andThen(doOnBind);
        return dup;
    }

    public final UdpServer doOnBound(Consumer<? super Connection> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super Connection> current = ((UdpServerConfig)dup.configuration()).doOnBound;
        ((UdpServerConfig)dup.configuration()).doOnBound = current == null ? doOnBound : current.andThen(doOnBound);
        return dup;
    }

    public final UdpServer doOnUnbound(Consumer<? super Connection> doOnUnbound) {
        Objects.requireNonNull(doOnUnbound, "doOnUnbound");
        UdpServer dup = (UdpServer)this.duplicate();
        Consumer<? super Connection> current = ((UdpServerConfig)dup.configuration()).doOnUnbound;
        ((UdpServerConfig)dup.configuration()).doOnUnbound = current == null ? doOnUnbound : current.andThen(doOnUnbound);
        return dup;
    }

    public final UdpServer handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnBound(new OnBoundHandle(handler));
    }

    public final UdpServer host(String host) {
        return this.bindAddress(() -> AddressUtils.updateHost(((UdpServerConfig)this.configuration()).bindAddress(), host));
    }

    @Override
    public final UdpServer metrics(boolean enable) {
        return (UdpServer)super.metrics(enable);
    }

    @Override
    public final UdpServer metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (UdpServer)super.metrics(enable, recorder);
    }

    @Override
    public final UdpServer observe(ConnectionObserver observer) {
        return (UdpServer)super.observe(observer);
    }

    @Override
    public final <O> UdpServer option(ChannelOption<O> key, @Nullable O value) {
        return (UdpServer)super.option(key, value);
    }

    public final UdpServer port(int port) {
        return this.bindAddress(() -> AddressUtils.updatePort(((UdpServerConfig)this.configuration()).bindAddress(), port));
    }

    @Override
    public final UdpServer runOn(EventLoopGroup eventLoopGroup) {
        return (UdpServer)super.runOn(eventLoopGroup);
    }

    @Override
    public final UdpServer runOn(LoopResources channelResources) {
        return (UdpServer)super.runOn(channelResources);
    }

    @Override
    public final UdpServer runOn(LoopResources loopResources, boolean preferNative) {
        Objects.requireNonNull(loopResources, "loopResources");
        UdpServer dup = (UdpServer)super.runOn(loopResources, preferNative);
        ((UdpServerConfig)dup.configuration()).family = null;
        ((UdpServerConfig)dup.configuration()).socketFamily = null;
        return dup;
    }

    @Deprecated
    public final UdpServer runOn(LoopResources loopResources, InternetProtocolFamily family) {
        Objects.requireNonNull(loopResources, "loopResources");
        Objects.requireNonNull(family, "family");
        UdpServer dup = (UdpServer)super.runOn(loopResources, false);
        ((UdpServerConfig)dup.configuration()).family = family;
        ((UdpServerConfig)dup.configuration()).socketFamily = family.toSocketProtocolFamily();
        return dup;
    }

    public final UdpServer runOn(LoopResources loopResources, SocketProtocolFamily family) {
        Objects.requireNonNull(loopResources, "loopResources");
        Objects.requireNonNull(family, "family");
        UdpServer dup = (UdpServer)super.runOn(loopResources, false);
        ((UdpServerConfig)dup.configuration()).family = null;
        ((UdpServerConfig)dup.configuration()).socketFamily = family;
        return dup;
    }

    public final Mono<Void> warmup() {
        return Mono.fromRunnable(() -> ((UdpServerConfig)this.configuration()).eventLoopGroup());
    }

    @Override
    public final UdpServer wiretap(boolean enable) {
        return (UdpServer)super.wiretap(enable);
    }

    @Override
    public final UdpServer wiretap(String category) {
        return (UdpServer)super.wiretap(category);
    }

    @Override
    public final UdpServer wiretap(String category, LogLevel level) {
        return (UdpServer)super.wiretap(category, level);
    }

    static final class OnBoundHandle
    implements Consumer<Connection> {
        final BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler;

        OnBoundHandle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Connection c) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), this.handler);
            }
            Mono.fromDirect(this.handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        }
    }
}

