/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

final class ReactorNettyLoggingHandler
extends LoggingHandler {
    private final AdvancedByteBufFormat byteBufFormat;
    private final @Nullable Charset charset;
    private final String name;
    static final char CHANNEL_ID_PREFIX = '[';
    static final char CHANNEL_ID_SUFFIX = ']';
    static final String ORIGINAL_CHANNEL_ID_PREFIX = "[id: 0x";
    static final int ORIGINAL_CHANNEL_ID_PREFIX_LENGTH = "[id: 0x".length();
    static final char TRACE_ID_PREFIX = '(';

    ReactorNettyLoggingHandler(String name, LogLevel level, AdvancedByteBufFormat byteBufFormat) {
        super(name, level, byteBufFormat == AdvancedByteBufFormat.SIMPLE ? ByteBufFormat.SIMPLE : ByteBufFormat.HEX_DUMP);
        this.byteBufFormat = byteBufFormat;
        this.charset = null;
        this.name = name;
    }

    ReactorNettyLoggingHandler(String name, LogLevel level, Charset charset) {
        super(name, level);
        this.byteBufFormat = AdvancedByteBufFormat.TEXTUAL;
        this.charset = Objects.requireNonNull(charset, "charset");
        this.name = name;
    }

    @Override
    public ByteBufFormat byteBufFormat() {
        if (this.byteBufFormat == AdvancedByteBufFormat.SIMPLE) {
            return ByteBufFormat.SIMPLE;
        }
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            return ByteBufFormat.HEX_DUMP;
        }
        throw new UnsupportedOperationException("ReactorNettyLoggingHandler isn't using the classic ByteBufFormat.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReactorNettyLoggingHandler)) {
            return false;
        }
        ReactorNettyLoggingHandler that = (ReactorNettyLoggingHandler)o;
        return this.byteBufFormat == that.byteBufFormat && Objects.equals(this.charset, that.charset) && this.level() == that.level() && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode((Object)this.byteBufFormat);
        result = 31 * result + Objects.hashCode(this.charset);
        result = 31 * result + Objects.hashCode((Object)this.level());
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName) {
        String chStr = ReactorNettyLoggingHandler.channelString(ctx.channel());
        return new StringBuilder(chStr.length() + 1 + eventName.length()).append(chStr).append(' ').append(eventName).toString();
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(ctx, eventName, (ByteBufHolder)arg);
        }
        return ReactorNettyLoggingHandler.formatSimple(ctx, eventName, arg);
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object firstArg, Object secondArg) {
        if (secondArg == null) {
            return ReactorNettyLoggingHandler.formatSimple(ctx, eventName, firstArg);
        }
        String chStr = ReactorNettyLoggingHandler.channelString(ctx.channel());
        String arg1Str = String.valueOf(firstArg);
        String arg2Str = secondArg.toString();
        return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + arg1Str.length() + 2 + arg2Str.length()).append(chStr).append(' ').append(eventName).append(": ").append(arg1Str).append(", ").append(arg2Str).toString();
    }

    private static String channelString(Channel channel) {
        StringBuilder result;
        Connection connection = Connection.from(channel);
        if (connection instanceof ChannelOperationsId) {
            String channelStr = ((ChannelOperationsId)((Object)connection)).asLongText();
            result = channelStr.charAt(0) != '(' ? new StringBuilder(1 + channelStr.length() + 1).append('[').append(channelStr).append(']') : new StringBuilder(channelStr);
        } else {
            String channelStr = channel.toString();
            if (channelStr.charAt(0) == '[') {
                channelStr = channelStr.substring(ORIGINAL_CHANNEL_ID_PREFIX_LENGTH);
                result = new StringBuilder(1 + channelStr.length()).append('[').append(channelStr);
            } else {
                int ind = channelStr.indexOf(ORIGINAL_CHANNEL_ID_PREFIX);
                result = new StringBuilder(1 + (channelStr.length() - ORIGINAL_CHANNEL_ID_PREFIX_LENGTH)).append(channelStr.substring(0, ind)).append('[').append(channelStr.substring(ind + ORIGINAL_CHANNEL_ID_PREFIX_LENGTH));
            }
        }
        return result.toString();
    }

    private String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        String chStr = ReactorNettyLoggingHandler.channelString(ctx.channel());
        int length = msg.readableBytes();
        if (length == 0) {
            return new StringBuilder(chStr.length() + 1 + eventName.length() + 4).append(chStr).append(' ').append(eventName).append(": 0B").toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        String message = "";
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        } else if (this.byteBufFormat == AdvancedByteBufFormat.TEXTUAL) {
            message = msg.toString(this.charset);
            outputLength += message.length() + 1;
        }
        StringBuilder buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(length).append('B');
        if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
            buf.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump(buf, msg);
        } else if (this.byteBufFormat == AdvancedByteBufFormat.TEXTUAL) {
            buf.append(' ').append(message);
        }
        return buf.toString();
    }

    private String formatByteBufHolder(ChannelHandlerContext ctx, String eventName, ByteBufHolder msg) {
        StringBuilder buf;
        String chStr = ReactorNettyLoggingHandler.channelString(ctx.channel());
        String msgStr = msg.toString();
        ByteBuf content = msg.content();
        int length = content.readableBytes();
        if (length == 0) {
            return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 4).append(chStr).append(' ').append(eventName).append(", ").append(msgStr).append(", 0B").toString();
        }
        if (this.byteBufFormat != AdvancedByteBufFormat.TEXTUAL) {
            int outputLength = chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 2 + 10 + 1;
            if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
                int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
                int hexDumpLength = 2 + rows * 80;
                outputLength += hexDumpLength;
            }
            buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(msgStr).append(", ").append(length).append('B');
            if (this.byteBufFormat == AdvancedByteBufFormat.HEX_DUMP) {
                buf.append(StringUtil.NEWLINE);
                ByteBufUtil.appendPrettyHexDump(buf, content);
            }
        } else {
            String message = content.toString(this.charset);
            int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 2 + message.length();
            buf = new StringBuilder(outputLength).append(chStr).append(' ').append(eventName).append(": ").append(length).append("B ").append(message);
        }
        return buf.toString();
    }

    private static String formatSimple(ChannelHandlerContext ctx, String eventName, Object msg) {
        String chStr = ReactorNettyLoggingHandler.channelString(ctx.channel());
        String msgStr = String.valueOf(msg);
        return new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length()).append(chStr).append(' ').append(eventName).append(": ").append(msgStr).toString();
    }
}

