/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.netty.transport.DomainSocketAddressUtils;
import reactor.util.annotation.Nullable;

public final class AddressUtils {
    private AddressUtils() {
    }

    public static InetSocketAddress createInetSocketAddress(String hostname, int port, boolean resolve) {
        Objects.requireNonNull(hostname, "hostname");
        InetSocketAddress inetAddressForIpString = AddressUtils.createForIpString(hostname, port);
        if (inetAddressForIpString != null) {
            return inetAddressForIpString;
        }
        return resolve ? new InetSocketAddress(hostname, port) : InetSocketAddress.createUnresolved(hostname, port);
    }

    public static InetSocketAddress createResolved(String hostname, int port) {
        return AddressUtils.createInetSocketAddress(hostname, port, true);
    }

    public static InetSocketAddress createUnresolved(String hostname, int port) {
        return AddressUtils.createInetSocketAddress(hostname, port, false);
    }

    public static InetSocketAddress parseAddress(String address, int defaultPort) {
        return AddressUtils.parseAddress(address, defaultPort, false);
    }

    public static InetSocketAddress parseAddress(String address, int defaultPort, boolean strict) {
        Objects.requireNonNull(address, "address");
        String host = address;
        int port = defaultPort;
        int separatorIdx = address.lastIndexOf(58);
        int ipV6HostSeparatorIdx = address.lastIndexOf(93);
        if (separatorIdx > ipV6HostSeparatorIdx) {
            if (separatorIdx == address.indexOf(58) || ipV6HostSeparatorIdx > -1) {
                host = address.substring(0, separatorIdx);
                String portStr = address.substring(separatorIdx + 1);
                if (!portStr.isEmpty()) {
                    if (portStr.chars().allMatch(Character::isDigit)) {
                        port = Integer.parseInt(portStr);
                    } else if (strict) {
                        throw new IllegalArgumentException("Failed to parse a port from " + address);
                    }
                }
            } else if (strict) {
                throw new IllegalArgumentException("Invalid IPv4 address " + address);
            }
        }
        return AddressUtils.createUnresolved(host, port);
    }

    public static InetSocketAddress replaceUnresolvedNumericIp(InetSocketAddress inetSocketAddress) {
        Objects.requireNonNull(inetSocketAddress, "inetSocketAddress");
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        InetSocketAddress inetAddressForIpString = AddressUtils.createForIpString(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        if (inetAddressForIpString != null) {
            return inetAddressForIpString;
        }
        return inetSocketAddress;
    }

    public static InetSocketAddress replaceWithResolved(InetSocketAddress inetSocketAddress) {
        Objects.requireNonNull(inetSocketAddress, "inetSocketAddress");
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        if (!(inetSocketAddress = AddressUtils.replaceUnresolvedNumericIp(inetSocketAddress)).isUnresolved()) {
            return inetSocketAddress;
        }
        return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }

    public static SocketAddress updateHost(@Nullable Supplier<? extends SocketAddress> address, String host) {
        if (address == null) {
            return AddressUtils.createUnresolved(host, 0);
        }
        SocketAddress socketAddress = address.get();
        if (DomainSocketAddressUtils.isDomainSocketAddress(socketAddress)) {
            throw new IllegalArgumentException("Cannot update DomainSocketAddress with host name [" + host + "].");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return AddressUtils.createUnresolved(host, 0);
        }
        InetSocketAddress inet = (InetSocketAddress)socketAddress;
        return AddressUtils.createUnresolved(host, inet.getPort());
    }

    public static SocketAddress updatePort(@Nullable Supplier<? extends SocketAddress> address, int port) {
        if (address == null) {
            return AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), port);
        }
        SocketAddress socketAddress = address.get();
        if (DomainSocketAddressUtils.isDomainSocketAddress(socketAddress)) {
            throw new IllegalArgumentException("Cannot update DomainSocketAddress with post number [" + port + "].");
        }
        if (!(address.get() instanceof InetSocketAddress)) {
            return AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), port);
        }
        InetSocketAddress inet = (InetSocketAddress)address.get();
        InetAddress addr = inet.getAddress();
        String host = addr == null ? inet.getHostName() : addr.getHostAddress();
        return AddressUtils.createUnresolved(host, port);
    }

    @Nullable
    static InetAddress attemptParsingIpString(String hostname) {
        byte[] ipAddressBytes = NetUtil.createByteArrayFromIpAddressString(hostname);
        if (ipAddressBytes != null) {
            try {
                if (ipAddressBytes.length == 4) {
                    return Inet4Address.getByAddress(ipAddressBytes);
                }
                return Inet6Address.getByAddress(null, ipAddressBytes, -1);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    static InetSocketAddress createForIpString(String hostname, int port) {
        InetAddress inetAddressForIpString = AddressUtils.attemptParsingIpString(hostname);
        if (inetAddressForIpString != null) {
            return new InetSocketAddress(inetAddressForIpString, port);
        }
        return null;
    }
}

