/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.Http3SslContextSpec;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientSecurityUtils;
import reactor.netty.http.internal.Http3;
import reactor.netty.tcp.SslProvider;

final class HttpClientSecure {
    static final SslProvider HTTP2_SSL_PROVIDER;
    static final SslProvider DEFAULT_HTTP3_SSL_PROVIDER;
    static final SslProvider DEFAULT_HTTP_SSL_PROVIDER;
    static final SslProvider DEFAULT_HTTP2_SSL_PROVIDER;

    private HttpClientSecure() {
    }

    static SslProvider defaultSslProvider(HttpClientConfig config) {
        if (config.checkProtocol(2)) {
            return DEFAULT_HTTP2_SSL_PROVIDER;
        }
        if (config.checkProtocol(8)) {
            return DEFAULT_HTTP3_SSL_PROVIDER;
        }
        return DEFAULT_HTTP_SSL_PROVIDER;
    }

    static boolean hasDefaultSslProvider(HttpClientConfig config) {
        return DEFAULT_HTTP_SSL_PROVIDER == config.sslProvider || DEFAULT_HTTP2_SSL_PROVIDER == config.sslProvider || DEFAULT_HTTP3_SSL_PROVIDER != null && DEFAULT_HTTP3_SSL_PROVIDER == config.sslProvider;
    }

    static SslProvider sslProvider(SslProvider sslProvider) {
        return SslProvider.addHandlerConfigurator(sslProvider, HttpClientSecurityUtils.HOSTNAME_VERIFICATION_CONFIGURER);
    }

    static {
        SslProvider sslProvider;
        try {
            sslProvider = SslProvider.builder().sslContext(Http2SslContextSpec.forClient()).build();
        }
        catch (Exception e) {
            sslProvider = null;
        }
        HTTP2_SSL_PROVIDER = sslProvider;
        try {
            sslProvider = !Http3.isHttp3Available() ? null : SslProvider.addHandlerConfigurator(SslProvider.builder().sslContext(Http3SslContextSpec.forClient()).build(), HttpClientSecurityUtils.HOSTNAME_VERIFICATION_CONFIGURER);
        }
        catch (Exception e) {
            sslProvider = null;
        }
        DEFAULT_HTTP3_SSL_PROVIDER = sslProvider;
        DEFAULT_HTTP_SSL_PROVIDER = SslProvider.addHandlerConfigurator(SslProvider.defaultClientProvider(), HttpClientSecurityUtils.HOSTNAME_VERIFICATION_CONFIGURER);
        DEFAULT_HTTP2_SSL_PROVIDER = SslProvider.addHandlerConfigurator(HTTP2_SSL_PROVIDER, HttpClientSecurityUtils.HOSTNAME_VERIFICATION_CONFIGURER);
    }
}

