/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.azblob;

import com.azure.core.credential.AzureSasCredential;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.StreamEmitter;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AZBlobEmitter
extends AbstractEmitter
implements Initializable,
StreamEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AZBlobEmitter.class);
    private String fileExtension = "json";
    private String prefix = "";
    private String sasToken;
    private String container;
    private String endpoint;
    private BlobServiceClient blobServiceClient;
    private BlobContainerClient blobContainerClient;
    private boolean overwriteExisting = false;

    public void emit(String emitKey, List<Metadata> metadataList, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.isEmpty()) {
            throw new TikaEmitterException("metadata list must not be null or of size 0");
        }
        UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            JsonMetadataList.toJson(metadataList, (Writer)writer);
        }
        catch (IOException e) {
            throw new TikaEmitterException("can't jsonify", (Throwable)e);
        }
        Metadata metadata = new Metadata();
        this.emit(emitKey, (InputStream)TikaInputStream.get((byte[])bos.toByteArray(), (Metadata)metadata), metadata, parseContext);
    }

    public void emit(String path, InputStream is, Metadata userMetadata, ParseContext parseContext) throws IOException, TikaEmitterException {
        String lengthString = userMetadata.get("Content-Length");
        long length = -1L;
        if (lengthString != null) {
            try {
                length = Long.parseLong(lengthString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Bad content-length: " + lengthString);
            }
        }
        if (is instanceof TikaInputStream && ((TikaInputStream)is).hasFile()) {
            this.write(path, userMetadata, ((TikaInputStream)is).getPath());
        } else if (length > -1L) {
            LOGGER.debug("relying on the content-length set in the metadata object: {}", (Object)length);
            this.write(path, userMetadata, is, length);
        } else {
            try (UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();){
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                this.write(path, userMetadata, bos.toByteArray());
            }
        }
    }

    private void write(String path, Metadata userMetadata, InputStream is, long length) {
        String actualPath = this.getActualPath(path);
        LOGGER.debug("about to emit to target container: ({}) path:({})", (Object)this.container, (Object)actualPath);
        BlobClient blobClient = this.blobContainerClient.getBlobClient(actualPath);
        this.updateMetadata(blobClient, userMetadata);
        blobClient.upload(is, length, this.overwriteExisting);
    }

    private void write(String path, Metadata userMetadata, Path file) {
        String actualPath = this.getActualPath(path);
        LOGGER.debug("about to emit to target container: ({}) path:({})", (Object)this.container, (Object)actualPath);
        BlobClient blobClient = this.blobContainerClient.getBlobClient(actualPath);
        this.updateMetadata(blobClient, userMetadata);
        blobClient.uploadFromFile(file.toAbsolutePath().toString(), this.overwriteExisting);
    }

    private void write(String path, Metadata userMetadata, byte[] bytes) throws IOException {
        String actualPath = this.getActualPath(path);
        LOGGER.debug("about to emit to target container: ({}) path:({})", (Object)this.container, (Object)actualPath);
        BlobClient blobClient = this.blobContainerClient.getBlobClient(actualPath);
        this.updateMetadata(blobClient, userMetadata);
        blobClient.upload((InputStream)UnsynchronizedByteArrayInputStream.builder().setByteArray(bytes).get(), bytes.length, this.overwriteExisting);
    }

    private void updateMetadata(BlobClient blobClient, Metadata userMetadata) {
        for (String n : userMetadata.names()) {
            if (n.equals("Content-Length")) continue;
            String[] vals = userMetadata.getValues(n);
            if (vals.length > 1) {
                LOGGER.warn("Can only write the first value for key {}. I see {} values.", (Object)n, (Object)vals.length);
            }
            blobClient.getProperties().getMetadata().put(n, vals[0]);
        }
    }

    private String getActualPath(String path) {
        Object ret = !StringUtils.isBlank((String)this.prefix) ? this.prefix + "/" + path : path;
        if (!StringUtils.isBlank((String)this.fileExtension)) {
            ret = (String)ret + "." + this.fileExtension;
        }
        return ret;
    }

    @Field
    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }

    @Field
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Field
    public void setContainer(String container) {
        this.container = container;
    }

    @Field
    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
    }

    @Field
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.blobServiceClient = new BlobServiceClientBuilder().endpoint(this.endpoint).credential(new AzureSasCredential(this.sasToken)).buildClient();
        this.blobContainerClient = this.blobServiceClient.getBlobContainerClient(this.container);
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"sasToken", (String)this.sasToken);
        TikaConfig.mustNotBeEmpty((String)"endpoint", (String)this.endpoint);
        TikaConfig.mustNotBeEmpty((String)"container", (String)this.container);
    }
}

