/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.complex;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroIntegerSchema;
import java.util.List;
import java.util.function.Consumer;

public class AvroEnumSchema
extends AvroCompositeSchema {
    private static final ClientLogger LOGGER = new ClientLogger(AvroEnumSchema.class);
    private final List<String> values;

    public AvroEnumSchema(List<String> symbols, AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
        this.values = symbols;
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroIntegerSchema indexSchema = new AvroIntegerSchema(this.state, this::onIndex);
        indexSchema.pushToStack();
    }

    private void onIndex(Object index) {
        AvroEnumSchema.checkType("index", index, Integer.class);
        Integer i = (Integer)index;
        if (i < 0 || i >= this.values.size()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Invalid index to parse enum"));
        }
        this.result = this.values.get(i);
        this.done = true;
    }
}

