/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.GeoObjectHelper;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonSubTypes(value={@JsonSubTypes.Type(name="Point", value=GeoPoint.class), @JsonSubTypes.Type(name="LineString", value=GeoLineString.class), @JsonSubTypes.Type(name="Polygon", value=GeoPolygon.class), @JsonSubTypes.Type(name="MultiPoint", value=GeoPointCollection.class), @JsonSubTypes.Type(name="MultiLineString", value=GeoLineStringCollection.class), @JsonSubTypes.Type(name="MultiPolygon", value=GeoPolygonCollection.class), @JsonSubTypes.Type(name="GeometryCollection", value=GeoCollection.class)})
public abstract class GeoObject
implements JsonSerializable<GeoObject> {
    private final GeoBoundingBox boundingBox;
    private final Map<String, Object> customProperties;

    protected GeoObject(GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this.boundingBox = boundingBox;
        this.customProperties = customProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(customProperties));
    }

    @JsonProperty(value="type")
    public abstract GeoObjectType getType();

    public final GeoBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public final Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.customProperties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoObject other = (GeoObject)obj;
        return Objects.equals(this.boundingBox, other.boundingBox) && Objects.equals(this.customProperties, other.customProperties);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeJsonField("bbox", this.getBoundingBox());
        Map<String, Object> customProperties = this.getCustomProperties();
        if (!CoreUtils.isNullOrEmpty(customProperties)) {
            jsonWriter.writeMap(customProperties, JsonWriter::writeUntyped);
        }
        return jsonWriter.writeEndObject();
    }

    public static GeoObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("type".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("Point".equals(discriminatorValue)) {
                return GeoPoint.fromJson(readerToUse);
            }
            if ("MultiPoint".equals(discriminatorValue)) {
                return GeoPointCollection.fromJson(readerToUse);
            }
            if ("Polygon".equals(discriminatorValue)) {
                return GeoPolygon.fromJson(readerToUse);
            }
            if ("MultiPolygon".equals(discriminatorValue)) {
                return GeoPolygonCollection.fromJson(readerToUse);
            }
            if ("LineString".equals(discriminatorValue)) {
                return GeoLineString.fromJson(readerToUse);
            }
            if ("MultiLineString".equals(discriminatorValue)) {
                return GeoLineStringCollection.fromJson(readerToUse);
            }
            if ("GeometryCollection".equals(discriminatorValue)) {
                return GeoCollection.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field 'type' didn't match one of the expected values 'Point', 'MultiPoint', 'Polygon', 'MultiPolygon', 'LineString', 'MultiLineString', or 'GeometryCollection'. It was: '" + discriminatorValue + "'.");
        });
    }

    JsonWriter writeCustomProperties(JsonWriter jsonWriter) throws IOException {
        if (!CoreUtils.isNullOrEmpty(this.customProperties)) {
            for (Map.Entry<String, Object> entry : this.customProperties.entrySet()) {
                jsonWriter.writeUntypedField(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return jsonWriter;
    }

    static {
        GeoObjectHelper.setAccessor(GeoObject::getCustomProperties);
    }
}

