/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

final class ColocatedEventLoopGroup
implements EventLoopGroup,
Supplier<EventLoopGroup> {
    final EventLoopGroup eventLoopGroup;
    final FastThreadLocal<EventLoop> localLoop = new FastThreadLocal();

    ColocatedEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        for (EventExecutor ex : eventLoopGroup) {
            if (!(ex instanceof EventLoop)) continue;
            EventLoop eventLoop = (EventLoop)ex;
            if (eventLoop.inEventLoop()) {
                if (this.localLoop.isSet()) continue;
                this.localLoop.set(eventLoop);
                continue;
            }
            eventLoop.submit(() -> {
                if (!this.localLoop.isSet()) {
                    this.localLoop.set(eventLoop);
                }
            });
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.eventLoopGroup.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.next().execute(command);
    }

    @Override
    public EventLoopGroup get() {
        return this.eventLoopGroup;
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.next().invokeAll(tasks);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.next().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.next().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.next().invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.eventLoopGroup.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.eventLoopGroup.isShuttingDown();
    }

    @Override
    public boolean isTerminated() {
        return this.eventLoopGroup.isTerminated();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.eventLoopGroup.iterator();
    }

    @Override
    public EventLoop next() {
        EventLoop loop = this.nextInternal();
        return loop != null ? loop : this.eventLoopGroup.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.next().schedule((Callable)callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.next().schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.next().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.next().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    @Deprecated
    public void shutdown() {
        this.shutdownGracefully();
    }

    @Override
    public Future<?> shutdownGracefully() {
        this.clean();
        return this.eventLoopGroup.shutdownGracefully();
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        this.clean();
        return this.eventLoopGroup.shutdownGracefully(quietPeriod, timeout, unit);
    }

    @Override
    @Deprecated
    public List<Runnable> shutdownNow() {
        this.clean();
        return this.eventLoopGroup.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.next().submit((Callable)task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.next().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.next().submit(task, (Object)result);
    }

    @Override
    public Future<?> terminationFuture() {
        return this.eventLoopGroup.terminationFuture();
    }

    void clean() {
        for (EventExecutor ex : this.eventLoopGroup) {
            ex.execute(() -> this.localLoop.set(null));
        }
    }

    @Nullable
    EventLoop nextInternal() {
        return this.localLoop.isSet() ? this.localLoop.get() : null;
    }
}

