/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpClientMetricsHandler.class);
    final SocketAddress proxyAddress;
    final SocketAddress remoteAddress;
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;
    int lastReadSeq;
    int lastWriteSeq;

    protected AbstractHttpClientMetricsHandler(SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress, @Nullable Function<String, String> uriTagValue) {
        this.proxyAddress = proxyAddress;
        this.remoteAddress = remoteAddress;
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpClientMetricsHandler(AbstractHttpClientMetricsHandler copy) {
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.method = copy.method;
        this.path = copy.path;
        this.proxyAddress = copy.proxyAddress;
        this.remoteAddress = copy.remoteAddress;
        this.status = copy.status;
        this.uriTagValue = copy.uriTagValue;
        this.lastWriteSeq = copy.lastWriteSeq;
        this.lastReadSeq = copy.lastReadSeq;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block4: {
            try {
                if (msg instanceof HttpRequest) {
                    this.extractDetailsFromHttpRequest(ctx, (HttpRequest)msg);
                }
                this.dataSent += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    int currentLastWriteSeq = this.lastWriteSeq;
                    promise.addListener(future -> {
                        block3: {
                            try {
                                if (currentLastWriteSeq == this.lastWriteSeq) {
                                    this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                                    this.recordWrite(this.remoteAddress);
                                }
                            }
                            catch (RuntimeException e) {
                                if (!log.isWarnEnabled()) break block3;
                                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                            }
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block5: {
            try {
                if (msg instanceof HttpResponse) {
                    this.status = ((HttpResponse)msg).status().codeAsText().toString();
                    this.startRead((HttpResponse)msg);
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.lastReadSeq = this.lastReadSeq + 1 & Integer.MAX_VALUE;
                    if (this.lastReadSeq > this.lastWriteSeq || this.lastReadSeq == 0 && this.lastWriteSeq == Integer.MAX_VALUE) {
                        this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                        this.recordWrite(this.remoteAddress);
                    }
                    this.recordRead(ctx.channel(), this.remoteAddress);
                    this.reset();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx);
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private void extractDetailsFromHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        this.method = request.method().name();
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            HttpClientOperations ops = (HttpClientOperations)channelOps;
            this.path = this.uriTagValue == null ? AbstractHttpClientMetricsHandler.resolvePath(ops) : this.uriTagValue.apply(AbstractHttpClientMetricsHandler.resolvePath(ops));
            this.contextView = ops.currentContextView();
        }
        this.startWrite(request, ctx.channel(), this.remoteAddress);
    }

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        if (this.proxyAddress == null) {
            this.recorder().incrementErrorsCount(this.remoteAddress, this.path != null ? this.path : this.resolveUri(ctx));
        } else {
            this.recorder().incrementErrorsCount(this.remoteAddress, this.proxyAddress, this.path != null ? this.path : this.resolveUri(ctx));
        }
    }

    protected void recordRead(Channel channel, SocketAddress address) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder().recordDataReceived(address, this.path, this.dataReceived);
        } else {
            this.recorder().recordDataReceivedTime(address, this.proxyAddress, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordResponseTime(address, this.proxyAddress, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder().recordDataReceived(address, this.proxyAddress, this.path, this.dataReceived);
        }
    }

    protected void recordWrite(SocketAddress address) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder().recordDataSent(address, this.path, this.dataSent);
        } else {
            this.recorder().recordDataSentTime(address, this.proxyAddress, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder().recordDataSent(address, this.proxyAddress, this.path, this.dataSent);
        }
    }

    protected void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }

    protected void startRead(HttpResponse msg) {
        this.dataReceivedTime = System.nanoTime();
    }

    protected void startWrite(HttpRequest msg, Channel channel, SocketAddress address) {
        this.dataSentTime = System.nanoTime();
    }

    static String resolvePath(HttpClientOperations ops) {
        try {
            return ops.fullPath();
        }
        catch (Exception e) {
            return "/bad-request";
        }
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path : this.uriTagValue.apply(path);
        }
        return "unknown";
    }
}

