/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.ProgressListener;
import com.azure.storage.blob.ProgressReceiver;
import com.azure.storage.common.implementation.StorageImplUtils;

public final class ParallelTransferOptions {
    private Long blockSize;
    private Integer maxConcurrency;
    private ProgressReceiver progressReceiver;
    private Long maxSingleUploadSize;

    public ParallelTransferOptions() {
    }

    @Deprecated
    public ParallelTransferOptions(Integer blockSize, Integer maxConcurrency, ProgressReceiver progressReceiver) {
        this(blockSize, maxConcurrency, progressReceiver, null);
    }

    @Deprecated
    public ParallelTransferOptions(Integer blockSize, Integer maxConcurrency, ProgressReceiver progressReceiver, Integer maxSingleUploadSize) {
        this.setBlockSizeLong(blockSize == null ? null : Long.valueOf(blockSize.intValue()));
        this.setMaxConcurrency(maxConcurrency);
        this.setProgressReceiver(progressReceiver);
        this.setMaxSingleUploadSizeLong(maxSingleUploadSize == null ? null : Long.valueOf(maxSingleUploadSize.intValue()));
    }

    @Deprecated
    public Integer getBlockSize() {
        return this.blockSize == null ? null : Integer.valueOf(Math.toIntExact(this.blockSize));
    }

    public Long getBlockSizeLong() {
        return this.blockSize;
    }

    public ParallelTransferOptions setBlockSizeLong(Long blockSize) {
        if (blockSize != null) {
            StorageImplUtils.assertInBounds("blockSize", blockSize, 1L, 0xFA000000L);
        }
        this.blockSize = blockSize;
        return this;
    }

    @Deprecated
    public Integer getNumBuffers() {
        return this.maxConcurrency;
    }

    @Deprecated
    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    @Deprecated
    public ParallelTransferOptions setProgressReceiver(ProgressReceiver progressReceiver) {
        this.progressReceiver = progressReceiver;
        return this;
    }

    public ParallelTransferOptions setProgressListener(ProgressListener progressListener) {
        this.progressReceiver = progressListener == null ? null : progressListener::handleProgress;
        return this;
    }

    public ProgressListener getProgressListener() {
        return this.progressReceiver;
    }

    @Deprecated
    public Integer getMaxSingleUploadSize() {
        return this.maxSingleUploadSize == null ? null : Integer.valueOf(Math.toIntExact(this.maxSingleUploadSize));
    }

    public Long getMaxSingleUploadSizeLong() {
        return this.maxSingleUploadSize;
    }

    public ParallelTransferOptions setMaxSingleUploadSizeLong(Long maxSingleUploadSize) {
        if (maxSingleUploadSize != null) {
            StorageImplUtils.assertInBounds("maxSingleUploadSize", maxSingleUploadSize, 1L, 5242880000L);
        }
        this.maxSingleUploadSize = maxSingleUploadSize;
        return this;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public ParallelTransferOptions setMaxConcurrency(Integer maxConcurrency) {
        if (maxConcurrency != null) {
            StorageImplUtils.assertInBounds("numBuffers", maxConcurrency.intValue(), 1L, Integer.MAX_VALUE);
        }
        this.maxConcurrency = maxConcurrency;
        return this;
    }
}

