/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class PropsUtil {
    public static Boolean getBoolean(String v, Boolean defaultMissing) {
        if (v == null || v.length() == 0) {
            return defaultMissing;
        }
        if (v.toLowerCase(Locale.ROOT).equals("true")) {
            return true;
        }
        if (v.toLowerCase(Locale.ROOT).equals("false")) {
            return false;
        }
        return defaultMissing;
    }

    public static Integer getInt(String v, Integer defaultMissing) {
        if (v == null || v.length() == 0) {
            return defaultMissing;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultMissing;
        }
    }

    public static Long getLong(String v, Long defaultMissing) {
        if (v == null || v.length() == 0) {
            return defaultMissing;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultMissing;
        }
    }

    public static String getString(String v, String defaultMissing) {
        if (v == null) {
            return defaultMissing;
        }
        return v;
    }

    public static Path getPath(String v, Path defaultMissing) {
        if (v == null || v.length() == 0) {
            return defaultMissing;
        }
        if (v.startsWith("\"")) {
            v = v.substring(1);
        }
        if (v.endsWith("\"")) {
            v = v.substring(0, v.length() - 1);
        }
        return Paths.get(v, new String[0]);
    }
}

