/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.processor;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.examples.FilterLinesByWord;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByWordInputProcessor
extends AbstractLogicalIOProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FilterByWordInputProcessor.class);
    private String filterWord;

    public FilterByWordInputProcessor(ProcessorContext context) {
        super(context);
    }

    public void initialize() throws Exception {
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.filterWord = conf.get("tez.runtime.examples.filterbyword.word");
        if (this.filterWord == null) {
            this.getContext().fatalError(null, "No filter word specified");
        }
    }

    public void handleEvents(List<Event> processorEvents) {
        throw new UnsupportedOperationException("Not expecting any events to the broadcast processor");
    }

    public void close() throws Exception {
        LOG.info("Broadcast Processor closing. Nothing to do");
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        String fileName;
        if (inputs.size() != 1) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with a single input");
        }
        if (outputs.size() != 1) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with a single output");
        }
        for (LogicalInput input : inputs.values()) {
            input.start();
        }
        for (LogicalOutput output : outputs.values()) {
            output.start();
        }
        LogicalInput li = inputs.values().iterator().next();
        if (!(li instanceof MRInput)) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with MRInput");
        }
        LogicalOutput lo = outputs.values().iterator().next();
        if (!(lo instanceof UnorderedKVOutput)) {
            throw new IllegalStateException("FilterByWordInputProcessor processor can only work with OnFileUnorderedKVOutput");
        }
        MRInputLegacy mrInput = (MRInputLegacy)li;
        mrInput.init();
        UnorderedKVOutput kvOutput = (UnorderedKVOutput)lo;
        Configuration updatedConf = mrInput.getConfigUpdates();
        Text srcFile = new Text();
        srcFile.set("UNKNOWN_FILENAME_IN_PROCESSOR");
        if (updatedConf != null && (fileName = updatedConf.get("mapreduce.map.input.file")) != null) {
            LOG.info("Processing file: " + fileName);
            srcFile.set(fileName);
        }
        KeyValueReader kvReader = mrInput.getReader();
        KeyValuesWriter kvWriter = kvOutput.getWriter();
        while (kvReader.next()) {
            Object key = kvReader.getCurrentKey();
            Object val = kvReader.getCurrentValue();
            Text valText = (Text)val;
            String readVal = valText.toString();
            if (!readVal.contains(this.filterWord)) continue;
            LongWritable lineNum = (LongWritable)key;
            FilterLinesByWord.TextLongPair outVal = new FilterLinesByWord.TextLongPair(srcFile, lineNum);
            kvWriter.write((Object)valText, (Object)outVal);
        }
    }
}

