/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.processor;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.mapreduce.processor.map.MapProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.input.UnorderedKVInput;

public class FilterByWordOutputProcessor
extends SimpleMRProcessor {
    private static final Log LOG = LogFactory.getLog(MapProcessor.class);

    public FilterByWordOutputProcessor(ProcessorContext context) {
        super(context);
    }

    public void handleEvents(List<Event> processorEvents) {
        throw new UnsupportedOperationException("Not expecting any events to the broadcast output processor");
    }

    public void close() throws Exception {
        LOG.info((Object)"Broadcast Output Processor closing. Nothing to do");
    }

    public void run() throws Exception {
        if (this.inputs.size() != 1) {
            throw new IllegalStateException("FilterByWordOutputProcessor processor can only work with a single input");
        }
        if (this.outputs.size() != 1) {
            throw new IllegalStateException("FilterByWordOutputProcessor processor can only work with a single output");
        }
        for (LogicalInput input : this.inputs.values()) {
            input.start();
        }
        for (LogicalOutput output : this.outputs.values()) {
            output.start();
        }
        LogicalInput li = (LogicalInput)this.inputs.values().iterator().next();
        if (!(li instanceof UnorderedKVInput)) {
            throw new IllegalStateException("FilterByWordOutputProcessor processor can only work with ShuffledUnorderedKVInput");
        }
        LogicalOutput lo = (LogicalOutput)this.outputs.values().iterator().next();
        if (!(lo instanceof MROutput)) {
            throw new IllegalStateException("FilterByWordOutputProcessor processor can only work with MROutput");
        }
        UnorderedKVInput kvInput = (UnorderedKVInput)li;
        MROutput mrOutput = (MROutput)lo;
        KeyValueReader kvReader = kvInput.getReader();
        KeyValueWriter kvWriter = mrOutput.getWriter();
        while (kvReader.next()) {
            Object key = kvReader.getCurrentKey();
            Object value = kvReader.getCurrentValue();
            kvWriter.write(key, value);
        }
    }
}

