/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.examples.ExampleDriver;
import org.apache.tez.mapreduce.examples.helpers.SplitsInClientOptionParser;
import org.apache.tez.mapreduce.examples.processor.FilterByWordInputProcessor;
import org.apache.tez.mapreduce.examples.processor.FilterByWordOutputProcessor;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.library.conf.UnorderedKVEdgeConfig;

public class FilterLinesByWord
extends Configured
implements Tool {
    private static Log LOG = LogFactory.getLog(FilterLinesByWord.class);
    public static final String FILTER_PARAM_NAME = "tez.runtime.examples.filterbyword.word";
    private boolean exitOnCompletion = false;

    public FilterLinesByWord(boolean exitOnCompletion) {
        this.exitOnCompletion = exitOnCompletion;
    }

    private static void printUsage() {
        System.err.println("Usage filtelinesrbyword <in> <out> <filter_word> [-generateSplitsInClient true/<false>]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        DataSourceDescriptor dsd;
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Credentials credentials = new Credentials();
        boolean generateSplitsInClient = false;
        SplitsInClientOptionParser splitCmdLineParser = new SplitsInClientOptionParser();
        try {
            generateSplitsInClient = splitCmdLineParser.parse(otherArgs, false);
            otherArgs = splitCmdLineParser.getRemainingArgs();
        }
        catch (ParseException e1) {
            System.err.println("Invalid options");
            FilterLinesByWord.printUsage();
            return 2;
        }
        if (otherArgs.length != 3) {
            FilterLinesByWord.printUsage();
            return 2;
        }
        String inputPath = otherArgs[0];
        String outputPath = otherArgs[1];
        String filterWord = otherArgs[2];
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(outputPath))) {
            System.err.println("Output directory : " + outputPath + " already exists");
            return 2;
        }
        TezConfiguration tezConf = new TezConfiguration(conf);
        fs.getWorkingDirectory();
        Path stagingDir = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        tezConf.set("tez.staging-dir", stagingDir.toString());
        TezClientUtils.ensureStagingDirExists((Configuration)tezConf, (Path)stagingDir);
        String jarPath = ClassUtil.findContainingJar(FilterLinesByWord.class);
        if (jarPath == null) {
            throw new TezUncheckedException("Could not find any jar containing" + FilterLinesByWord.class.getName() + " in the classpath");
        }
        Path remoteJarPath = fs.makeQualified(new Path(stagingDir, "dag_job.jar"));
        fs.copyFromLocalFile(new Path(jarPath), remoteJarPath);
        FileStatus remoteJarStatus = fs.getFileStatus(remoteJarPath);
        TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])new Path[]{remoteJarPath}, (Configuration)conf);
        TreeMap<String, LocalResource> commonLocalResources = new TreeMap<String, LocalResource>();
        LocalResource dagJarLocalRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)remoteJarPath), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)remoteJarStatus.getLen(), (long)remoteJarStatus.getModificationTime());
        commonLocalResources.put("dag_job.jar", dagJarLocalRsrc);
        TezClient tezSession = TezClient.create((String)"FilterLinesByWordSession", (TezConfiguration)tezConf, commonLocalResources, (Credentials)credentials);
        tezSession.start();
        JobConf stage1Conf = new JobConf(conf);
        stage1Conf.set(FILTER_PARAM_NAME, filterWord);
        JobConf stage2Conf = new JobConf(conf);
        stage2Conf.set("mapreduce.output.fileoutputformat.outputdir", outputPath);
        stage2Conf.setBoolean("mapred.mapper.new-api", false);
        UserPayload stage1Payload = TezUtils.createUserPayloadFromConf((Configuration)stage1Conf);
        Vertex stage1Vertex = Vertex.create((String)"stage1", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)FilterByWordInputProcessor.class.getName()).setUserPayload(stage1Payload))).addTaskLocalFiles(commonLocalResources);
        if (generateSplitsInClient) {
            stage1Conf.set("mapreduce.input.fileinputformat.inputdir", inputPath);
            stage1Conf.setBoolean("mapred.mapper.new-api", false);
            dsd = MRInputHelpers.configureMRInputWithLegacySplitGeneration((Configuration)stage1Conf, (Path)stagingDir, (boolean)true);
        } else {
            dsd = MRInputLegacy.createConfigBuilder((Configuration)stage1Conf, TextInputFormat.class, (String)inputPath).groupSplits(false).build();
        }
        stage1Vertex.addDataSource("MRInput", dsd);
        Vertex stage2Vertex = Vertex.create((String)"stage2", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)FilterByWordOutputProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)stage2Conf))), (int)1);
        stage2Vertex.addTaskLocalFiles(commonLocalResources);
        OutputDescriptor od = (OutputDescriptor)OutputDescriptor.create((String)MROutput.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)stage2Conf));
        OutputCommitterDescriptor ocd = OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName());
        stage2Vertex.addDataSink("MROutput", new DataSinkDescriptor(od, ocd, null));
        UnorderedKVEdgeConfig edgeConf = UnorderedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)TextLongPair.class.getName()).build();
        DAG dag = DAG.create((String)"FilterLinesByWord");
        Edge edge = Edge.create((Vertex)stage1Vertex, (Vertex)stage2Vertex, (EdgeProperty)edgeConf.createDefaultBroadcastEdgeProperty());
        dag.addVertex(stage1Vertex).addVertex(stage2Vertex).addEdge(edge);
        LOG.info((Object)"Submitting DAG to Tez Session");
        DAGClient dagClient = tezSession.submitDAG(dag);
        LOG.info((Object)"Submitted DAG to Tez Session");
        DAGStatus dagStatus = null;
        String[] vNames = new String[]{"stage1", "stage2"};
        try {
            while ((dagStatus = dagClient.getDAGStatus(null)).getState() != DAGStatus.State.RUNNING && dagStatus.getState() != DAGStatus.State.SUCCEEDED && dagStatus.getState() != DAGStatus.State.FAILED && dagStatus.getState() != DAGStatus.State.KILLED && dagStatus.getState() != DAGStatus.State.ERROR) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            while (dagStatus.getState() == DAGStatus.State.RUNNING) {
                try {
                    ExampleDriver.printDAGStatus(dagClient, vNames);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    dagStatus = dagClient.getDAGStatus(null);
                }
                catch (TezException e) {
                    LOG.fatal((Object)"Failed to get application progress. Exiting");
                    int n = -1;
                    fs.delete(stagingDir, true);
                    tezSession.stop();
                    return n;
                }
            }
            dagStatus = dagClient.getDAGStatus((Set)Sets.newHashSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        }
        finally {
            fs.delete(stagingDir, true);
            tezSession.stop();
        }
        ExampleDriver.printDAGStatus(dagClient, vNames, true, true);
        LOG.info((Object)("Application completed. FinalState=" + dagStatus.getState()));
        return dagStatus.getState() == DAGStatus.State.SUCCEEDED ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        FilterLinesByWord fl = new FilterLinesByWord(true);
        int status = ToolRunner.run((Configuration)new Configuration(), (Tool)fl, (String[])args);
        if (fl.exitOnCompletion) {
            System.exit(status);
        }
    }

    public static class TextLongPair
    implements Writable {
        private Text text;
        private LongWritable longWritable;

        public TextLongPair() {
        }

        public TextLongPair(Text text, LongWritable longWritable) {
            this.text = text;
            this.longWritable = longWritable;
        }

        public void write(DataOutput out) throws IOException {
            this.text.write(out);
            this.longWritable.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.text = new Text();
            this.longWritable = new LongWritable();
            this.text.readFields(in);
            this.longWritable.readFields(in);
        }

        public String toString() {
            return this.text.toString() + "\t" + this.longWritable.get();
        }
    }
}

