/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;
import org.apache.tez.runtime.library.utils.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFile {
    private static final Logger LOG = LoggerFactory.getLogger(IFile.class);
    public static final int EOF_MARKER = -1;
    public static final int RLE_MARKER = -2;
    public static final int V_END_MARKER = -3;
    public static final DataInputBuffer REPEAT_KEY = new DataInputBuffer();
    static final byte[] HEADER = new byte[]{84, 73, 70, 0};
    private static final String INCOMPLETE_READ = "Requested to read %d got %d";

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Reader {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private long numRecordsRead = 0L;
        private final TezCounter readRecordsCounter;
        private final TezCounter bytesReadCounter;
        final InputStream in;
        Decompressor decompressor;
        public long bytesRead = 0L;
        final long fileLength;
        protected boolean eof = false;
        IFileInputStream checksumIn;
        protected byte[] buffer = null;
        protected int bufferSize = 131072;
        protected DataInputStream dataIn = null;
        protected int recNo = 1;
        protected int originalKeyLength;
        protected int prevKeyLength;
        byte[] keyBytes = new byte[0];
        protected int currentKeyLength;
        protected int currentValueLength;
        long startPos;

        public Reader(FileSystem fs, Path file, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize) throws IOException {
            this((InputStream)fs.open(file), fs.getFileStatus(file).getLen(), codec, readsCounter, bytesReadCounter, ifileReadAhead, ifileReadAheadLength, bufferSize);
        }

        public Reader(InputStream in, long length, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean readAhead, int readAheadLength, int bufferSize) throws IOException {
            this(in, in != null ? length - (long)HEADER.length : length, codec, readsCounter, bytesReadCounter, readAhead, readAheadLength, bufferSize, in != null ? Reader.isCompressedFlagEnabled(in) : false);
            if (in != null && bytesReadCounter != null) {
                bytesReadCounter.increment((long)HEADER.length);
            }
        }

        public Reader(InputStream in, long length, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean readAhead, int readAheadLength, int bufferSize, boolean isCompressed) throws IOException {
            if (in != null) {
                this.checksumIn = new IFileInputStream(in, length, readAhead, readAheadLength);
                if (isCompressed && codec != null) {
                    this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                    if (this.decompressor != null) {
                        this.in = codec.createInputStream((InputStream)this.checksumIn, this.decompressor);
                    } else {
                        LOG.warn("Could not obtain decompressor from CodecPool");
                        this.in = this.checksumIn;
                    }
                } else {
                    this.in = this.checksumIn;
                }
                this.startPos = this.checksumIn.getPosition();
            } else {
                this.in = null;
            }
            if (in != null) {
                this.dataIn = new DataInputStream(this.in);
            }
            this.readRecordsCounter = readsCounter;
            this.bytesReadCounter = bytesReadCounter;
            this.fileLength = length;
            this.bufferSize = Math.max(0, bufferSize);
        }

        public static void readToMemory(byte[] buffer, InputStream in, int compressedLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength) throws IOException {
            boolean isCompressed = Reader.isCompressedFlagEnabled(in);
            IFileInputStream checksumIn = new IFileInputStream(in, compressedLength - HEADER.length, ifileReadAhead, ifileReadAheadLength);
            in = checksumIn;
            Decompressor decompressor = null;
            if (isCompressed && codec != null) {
                decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (decompressor != null) {
                    decompressor.reset();
                    in = codec.createInputStream((InputStream)checksumIn, decompressor);
                } else {
                    LOG.warn("Could not obtain decompressor from CodecPool");
                    in = checksumIn;
                }
            }
            try {
                IOUtils.readFully((InputStream)in, (byte[])buffer, (int)0, (int)(buffer.length - HEADER.length));
                if (in.read() >= 0) {
                    throw new IOException("Unexpected extra bytes from input stream");
                }
            }
            catch (IOException ioe) {
                block14: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block14;
                            LOG.debug("Exception in closing " + in, (Throwable)e);
                        }
                    }
                }
                throw ioe;
            }
            finally {
                if (decompressor != null) {
                    decompressor.reset();
                    CodecPool.returnDecompressor((Decompressor)decompressor);
                }
            }
        }

        public static long readToDisk(OutputStream out, InputStream in, long length, boolean ifileReadAhead, int ifileReadAheadLength) throws IOException {
            int n;
            long bytesLeft;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            if (length < (long)HEADER.length) {
                throw new IOException("Missing IFile header");
            }
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)HEADER.length);
            Reader.verifyHeaderMagic(buf);
            out.write(buf, 0, HEADER.length);
            IFileInputStream ifInput = new IFileInputStream(in, bytesLeft, ifileReadAhead, ifileReadAheadLength);
            for (bytesLeft = length - (long)HEADER.length; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = ifInput.readWithChecksum(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream");
                }
                out.write(buf, 0, n);
            }
            return length - bytesLeft;
        }

        public long getLength() {
            return this.fileLength - this.checksumIn.getSize();
        }

        public long getPosition() throws IOException {
            return this.checksumIn.getPosition();
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = IOUtils.wrappedReadForCompressedData((InputStream)this.in, (byte[])buf, (int)(off + bytesRead), (int)(len - bytesRead));
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        protected void readValueLength(DataInput dIn) throws IOException {
            this.currentValueLength = WritableUtils.readVInt((DataInput)dIn);
            this.bytesRead += (long)WritableUtils.getVIntSize((long)this.currentValueLength);
            if (this.currentValueLength == -3) {
                this.readKeyValueLength(dIn);
            }
        }

        protected void readKeyValueLength(DataInput dIn) throws IOException {
            this.currentKeyLength = WritableUtils.readVInt((DataInput)dIn);
            this.currentValueLength = WritableUtils.readVInt((DataInput)dIn);
            if (this.currentKeyLength != -2) {
                this.originalKeyLength = this.currentKeyLength;
            }
            this.bytesRead += (long)(WritableUtils.getVIntSize((long)this.currentKeyLength) + WritableUtils.getVIntSize((long)this.currentValueLength));
        }

        protected boolean positionToNextRecord(DataInput dIn) throws IOException {
            if (this.eof) {
                throw new IOException(String.format("Reached EOF. Completed reading %d", this.bytesRead));
            }
            this.prevKeyLength = this.currentKeyLength;
            if (this.prevKeyLength == -2) {
                this.readValueLength(dIn);
            } else {
                this.readKeyValueLength(dIn);
            }
            if (this.currentKeyLength == -1 && this.currentValueLength == -1) {
                this.eof = true;
                return false;
            }
            if (this.currentKeyLength != -2 && this.currentKeyLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + this.currentKeyLength + " PreviousKeyLen: " + this.prevKeyLength);
            }
            if (this.currentValueLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + this.currentValueLength);
            }
            return true;
        }

        public final boolean nextRawKey(DataInputBuffer key) throws IOException {
            return this.readRawKey(key) != KeyState.NO_KEY;
        }

        public KeyState readRawKey(DataInputBuffer key) throws IOException {
            int i;
            if (!this.positionToNextRecord(this.dataIn)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("currentKeyLength=" + this.currentKeyLength + ", currentValueLength=" + this.currentValueLength + ", bytesRead=" + this.bytesRead + ", length=" + this.fileLength);
                }
                return KeyState.NO_KEY;
            }
            if (this.currentKeyLength == -2) {
                key.reset(this.keyBytes, this.originalKeyLength);
                return KeyState.SAME_KEY;
            }
            if (this.keyBytes.length < this.currentKeyLength) {
                this.keyBytes = new byte[this.currentKeyLength << 1];
            }
            if ((i = this.readData(this.keyBytes, 0, this.currentKeyLength)) != this.currentKeyLength) {
                throw new IOException(String.format(IFile.INCOMPLETE_READ, this.currentKeyLength, i));
            }
            key.reset(this.keyBytes, this.currentKeyLength);
            this.bytesRead += (long)this.currentKeyLength;
            return KeyState.NEW_KEY;
        }

        public void nextRawValue(DataInputBuffer value) throws IOException {
            byte[] valBytes = value.getData().length < this.currentValueLength || value.getData() == this.keyBytes ? new byte[this.currentValueLength << 1] : value.getData();
            int i = this.readData(valBytes, 0, this.currentValueLength);
            if (i != this.currentValueLength) {
                throw new IOException(String.format(IFile.INCOMPLETE_READ, this.currentValueLength, i));
            }
            value.reset(valBytes, this.currentValueLength);
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
            ++this.numRecordsRead;
        }

        private static void verifyHeaderMagic(byte[] header) throws IOException {
            if (header[0] != 84 || header[1] != 73 || header[2] != 70) {
                throw new IOException("Not a valid ifile header");
            }
        }

        public static boolean isCompressedFlagEnabled(InputStream in) throws IOException {
            byte[] header = new byte[HEADER.length];
            IOUtils.readFully((InputStream)in, (byte[])header, (int)0, (int)HEADER.length);
            Reader.verifyHeaderMagic(header);
            return header[3] == 1;
        }

        public void close() throws IOException {
            this.in.close();
            this.dataIn = null;
            this.buffer = null;
            if (this.readRecordsCounter != null) {
                this.readRecordsCounter.increment(this.numRecordsRead);
            }
            if (this.bytesReadCounter != null) {
                this.bytesReadCounter.increment(this.checksumIn.getPosition() - this.startPos + this.checksumIn.getSize());
            }
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }

        public void reset(int offset) {
        }

        public void disableChecksumValidation() {
            this.checksumIn.disableChecksumValidation();
        }

        public static enum KeyState {
            NO_KEY,
            NEW_KEY,
            SAME_KEY;

        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Writer {
        protected DataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        FSDataOutputStream rawOut;
        final AtomicBoolean closed = new AtomicBoolean(false);
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        private long numRecordsWritten = 0L;
        private long rleWritten = 0L;
        private long totalKeySaving = 0L;
        private final TezCounter writtenRecordsCounter;
        private final TezCounter serializedUncompressedBytes;
        IFileOutputStream checksumOut;
        boolean closeSerializers = false;
        Serializer keySerializer = null;
        Serializer valueSerializer = null;
        final DataOutputBuffer buffer = new DataOutputBuffer();
        final DataOutputBuffer previous = new DataOutputBuffer();
        Object prevKey = null;
        boolean headerWritten = false;
        @VisibleForTesting
        boolean sameKey = false;
        final int RLE_MARKER_SIZE = WritableUtils.getVIntSize((long)-2L);
        final int V_END_MARKER_SIZE = WritableUtils.getVIntSize((long)-3L);
        protected final boolean rle;

        public Writer(Configuration conf, FileSystem fs, Path file, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec, writesCounter, serializedBytesCounter);
            this.ownOutputStream = true;
        }

        protected Writer(TezCounter writesCounter, TezCounter serializedBytesCounter) {
            this.writtenRecordsCounter = writesCounter;
            this.serializedUncompressedBytes = serializedBytesCounter;
            this.rle = false;
        }

        public Writer(Configuration conf, FSDataOutputStream outputStream, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter) throws IOException {
            this(conf, outputStream, keyClass, valueClass, codec, writesCounter, serializedBytesCounter, false);
        }

        public Writer(Configuration conf, FSDataOutputStream outputStream, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter, boolean rle) throws IOException {
            this.rawOut = outputStream;
            this.writtenRecordsCounter = writesCounter;
            this.serializedUncompressedBytes = serializedBytesCounter;
            this.checksumOut = new IFileOutputStream((OutputStream)outputStream);
            this.start = this.rawOut.getPos();
            this.rle = rle;
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (this.compressor != null) {
                    this.compressor.reset();
                    this.compressedOut = codec.createOutputStream((OutputStream)this.checksumOut, this.compressor);
                    this.out = new FSDataOutputStream((OutputStream)this.compressedOut, null);
                    this.compressOutput = true;
                } else {
                    LOG.warn("Could not obtain compressor from CodecPool");
                    this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
                }
            } else {
                this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
            }
            this.writeHeader((OutputStream)outputStream);
            if (keyClass != null) {
                this.closeSerializers = true;
                SerializationFactory serializationFactory = new SerializationFactory(conf);
                this.keySerializer = serializationFactory.getSerializer(keyClass);
                this.keySerializer.open((OutputStream)this.buffer);
                this.valueSerializer = serializationFactory.getSerializer(valueClass);
                this.valueSerializer.open((OutputStream)this.buffer);
            } else {
                this.closeSerializers = false;
            }
        }

        public Writer(Configuration conf, FileSystem fs, Path file) throws IOException {
            this(conf, fs, file, null, null, null, null, null);
        }

        protected void writeHeader(OutputStream outputStream) throws IOException {
            if (!this.headerWritten) {
                outputStream.write(HEADER, 0, HEADER.length - 1);
                outputStream.write(this.compressOutput ? 1 : 0);
                outputStream.flush();
                this.headerWritten = true;
            }
        }

        public void close() throws IOException {
            if (this.closed.getAndSet(true)) {
                throw new IOException("Writer was already closed earlier");
            }
            if (this.closeSerializers) {
                this.keySerializer.close();
                this.valueSerializer.close();
            }
            this.writeValueMarker(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize((long)-1L));
            this.decompressedBytesWritten += (long)HEADER.length;
            this.out.flush();
            if (this.ownOutputStream) {
                this.out.close();
            } else {
                if (this.compressOutput) {
                    this.compressedOut.finish();
                    this.compressedOut.resetState();
                }
                this.checksumOut.finish();
            }
            this.compressedBytesWritten = this.rawOut.getPos() - this.start;
            if (this.compressOutput) {
                CodecPool.returnCompressor((Compressor)this.compressor);
                this.compressor = null;
            }
            this.out = null;
            if (this.writtenRecordsCounter != null) {
                this.writtenRecordsCounter.increment(this.numRecordsWritten);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Total keys written=" + this.numRecordsWritten + "; rleEnabled=" + this.rle + "; Savings" + "(due to multi-kv/rle)=" + this.totalKeySaving + "; number of RLEs written=" + this.rleWritten + "; compressedLen=" + this.compressedBytesWritten + "; rawLen=" + this.decompressedBytesWritten);
            }
        }

        public void append(Object key, Object value) throws IOException {
            int keyLength = 0;
            boolean bl = this.sameKey = key == REPEAT_KEY;
            if (!this.sameKey) {
                this.keySerializer.serialize(key);
                keyLength = this.buffer.getLength();
                assert (keyLength >= 0);
                if (this.rle && keyLength == this.previous.getLength()) {
                    this.sameKey = BufferUtils.compare(this.previous, this.buffer) == 0;
                }
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            assert (valueLength >= 0);
            if (!this.sameKey) {
                this.writeKVPair(this.buffer.getData(), 0, keyLength, this.buffer.getData(), keyLength, this.buffer.getLength() - keyLength);
                if (this.rle) {
                    this.previous.reset();
                    this.previous.write(this.buffer.getData(), 0, keyLength);
                }
            } else {
                this.writeValue(this.buffer.getData(), keyLength, valueLength);
            }
            this.prevKey = this.sameKey ? REPEAT_KEY : key;
            this.buffer.reset();
            ++this.numRecordsWritten;
        }

        public void appendValue(Object value) throws IOException {
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength();
            this.writeValue(this.buffer.getData(), 0, valueLength);
            this.buffer.reset();
            ++this.numRecordsWritten;
            this.prevKey = REPEAT_KEY;
        }

        public void appendValue(DataInputBuffer value) throws IOException {
            int valueLength = value.getLength() - value.getPosition();
            assert (valueLength >= 0);
            this.writeValue(value.getData(), value.getPosition(), valueLength);
            this.buffer.reset();
            ++this.numRecordsWritten;
            this.prevKey = REPEAT_KEY;
        }

        public <V> void appendValues(Iterator<V> valuesItr) throws IOException {
            while (valuesItr.hasNext()) {
                this.appendValue(valuesItr.next());
            }
        }

        public <K, V> void appendKeyValues(K key, Iterator<V> valuesItr) throws IOException {
            if (valuesItr.hasNext()) {
                this.append(key, valuesItr.next());
            }
            while (valuesItr.hasNext()) {
                this.appendValue(valuesItr.next());
            }
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            assert (key == REPEAT_KEY || keyLength >= 0);
            int valueLength = value.getLength() - value.getPosition();
            assert (valueLength >= 0);
            boolean bl = this.sameKey = key == REPEAT_KEY;
            if (!this.sameKey && this.rle) {
                boolean bl2 = this.sameKey = keyLength != 0 && BufferUtils.compare(this.previous, key) == 0;
            }
            if (!this.sameKey) {
                this.writeKVPair(key.getData(), key.getPosition(), keyLength, value.getData(), value.getPosition(), valueLength);
                if (this.rle) {
                    BufferUtils.copy(key, this.previous);
                }
            } else {
                this.writeValue(value.getData(), value.getPosition(), valueLength);
            }
            this.prevKey = this.sameKey ? REPEAT_KEY : key;
            ++this.numRecordsWritten;
        }

        protected void writeValue(byte[] data, int offset, int length) throws IOException {
            this.writeRLE(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)length);
            this.out.write(data, offset, length);
            this.decompressedBytesWritten += (long)(length + WritableUtils.getVIntSize((long)length));
            if (this.serializedUncompressedBytes != null) {
                this.serializedUncompressedBytes.increment((long)length);
            }
            ++this.totalKeySaving;
        }

        protected void writeKVPair(byte[] keyData, int keyPos, int keyLength, byte[] valueData, int valPos, int valueLength) throws IOException {
            this.writeValueMarker(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(keyData, keyPos, keyLength);
            this.out.write(valueData, valPos, valueLength);
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
            if (this.serializedUncompressedBytes != null) {
                this.serializedUncompressedBytes.increment((long)(keyLength + valueLength));
            }
        }

        protected void writeRLE(DataOutputStream out) throws IOException {
            if (this.prevKey != REPEAT_KEY) {
                WritableUtils.writeVInt((DataOutput)out, (int)-2);
                this.decompressedBytesWritten += (long)this.RLE_MARKER_SIZE;
                ++this.rleWritten;
            }
        }

        protected void writeValueMarker(DataOutputStream out) throws IOException {
            if (this.prevKey == REPEAT_KEY) {
                WritableUtils.writeVInt((DataOutput)out, (int)-3);
                this.decompressedBytesWritten += (long)this.V_END_MARKER_SIZE;
            }
        }

        public DataOutputStream getOutputStream() {
            return this.out;
        }

        public void updateCountersForExternalAppend(long length) {
            ++this.numRecordsWritten;
            this.decompressedBytesWritten += length;
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }
    }
}

