/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.ValuesIterator;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.Shuffle;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class OrderedGroupedKVInput
extends AbstractLogicalInput {
    static final Logger LOG = LoggerFactory.getLogger(OrderedGroupedKVInput.class);
    protected TezRawKeyValueIterator rawIter = null;
    protected Configuration conf;
    protected Shuffle shuffle;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private long firstEventReceivedTime = -1L;
    protected ValuesIterator vIter;
    private TezCounter inputKeyCounter;
    private TezCounter inputValueCounter;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final Set<String> confKeys = new HashSet<String>();

    public OrderedGroupedKVInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public synchronized List<Event> initialize() throws IOException {
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        if (this.getNumPhysicalInputs() == 0) {
            this.getContext().requestInitialMemory(0L, null);
            this.isStarted.set(true);
            this.getContext().inputIsReady();
            LOG.info("input fetch not required since there are 0 physical inputs for input vertex: " + this.getContext().getSourceVertexName());
            return Collections.emptyList();
        }
        long initialMemoryRequest = Shuffle.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(initialMemoryRequest, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.inputKeyCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_GROUPS);
        this.inputValueCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_RECORDS);
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        return Collections.emptyList();
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.shuffle = this.createShuffle();
            this.shuffle.run();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized the handlers in shuffle..Safe to start processing..");
            }
            LinkedList<Event> pending = new LinkedList<Event>();
            this.pendingEvents.drainTo(pending);
            if (pending.size() > 0) {
                LOG.info("NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime));
                this.shuffle.handleEvents(pending);
            }
            this.isStarted.set(true);
        }
    }

    @VisibleForTesting
    Shuffle createShuffle() throws IOException {
        return new Shuffle(this.getContext(), this.conf, this.getNumPhysicalInputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
    }

    public synchronized boolean isInputReady() throws IOException, InterruptedException, TezException {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Must start input before invoking this method");
        if (this.getNumPhysicalInputs() == 0) {
            return true;
        }
        return this.shuffle.isInputReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInputReady() throws IOException, InterruptedException, TezException {
        Shuffle localShuffleCopy = null;
        OrderedGroupedKVInput orderedGroupedKVInput = this;
        synchronized (orderedGroupedKVInput) {
            Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Must start input before invoking this method");
            if (this.getNumPhysicalInputs() == 0) {
                return;
            }
            localShuffleCopy = this.shuffle;
        }
        TezRawKeyValueIterator localRawIter = localShuffleCopy.waitForInput();
        OrderedGroupedKVInput orderedGroupedKVInput2 = this;
        synchronized (orderedGroupedKVInput2) {
            this.rawIter = localRawIter;
            this.createValuesIterator();
        }
    }

    public synchronized List<Event> close() throws IOException {
        if (this.getNumPhysicalInputs() != 0 && this.rawIter != null) {
            this.rawIter.close();
        }
        if (this.shuffle != null) {
            this.shuffle.shutdown();
        }
        long dataSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(dataSize);
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_RECORDS).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValuesReader getReader() throws IOException, TezException {
        TezRawKeyValueIterator rawIterLocal;
        OrderedGroupedKVInput orderedGroupedKVInput = this;
        synchronized (orderedGroupedKVInput) {
            rawIterLocal = this.rawIter;
            if (this.getNumPhysicalInputs() == 0) {
                return new KeyValuesReader(){

                    @Override
                    public boolean next() throws IOException {
                        this.hasCompletedProcessing();
                        this.completedProcessing = true;
                        return false;
                    }

                    @Override
                    public Object getCurrentKey() throws IOException {
                        throw new RuntimeException("No data available in Input");
                    }

                    @Override
                    public Iterable<Object> getCurrentValues() throws IOException {
                        throw new RuntimeException("No data available in Input");
                    }
                };
            }
        }
        if (rawIterLocal == null) {
            try {
                this.waitForInputReady();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOInterruptedException("Interrupted while waiting for input ready", e);
            }
        }
        ValuesIterator valuesIter = null;
        OrderedGroupedKVInput orderedGroupedKVInput2 = this;
        synchronized (orderedGroupedKVInput2) {
            valuesIter = this.vIter;
        }
        return new OrderedGroupedKeyValuesReader(valuesIter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        Shuffle shuffleLocalRef;
        OrderedGroupedKVInput orderedGroupedKVInput = this;
        synchronized (orderedGroupedKVInput) {
            if (this.getNumPhysicalInputs() == 0) {
                throw new RuntimeException("No input events expected as numInputs is 0");
            }
            if (!this.isStarted.get()) {
                if (this.firstEventReceivedTime == -1L) {
                    this.firstEventReceivedTime = System.currentTimeMillis();
                }
                this.pendingEvents.addAll(inputEvents);
                return;
            }
            shuffleLocalRef = this.shuffle;
        }
        shuffleLocalRef.handleEvents(inputEvents);
    }

    protected synchronized void createValuesIterator() throws IOException {
        this.vIter = new ValuesIterator(this.rawIter, ConfigUtils.getIntermediateInputKeyComparator(this.conf), ConfigUtils.getIntermediateInputKeyClass(this.conf), ConfigUtils.getIntermediateInputValueClass(this.conf), this.conf, this.inputKeyCounter, this.inputValueCounter);
    }

    public RawComparator getInputKeyComparator() {
        return ConfigUtils.getIntermediateInputKeyComparator(this.conf);
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.io.sort.factor");
        confKeys.add("tez.runtime.combine.min.spills");
        confKeys.add("tez.runtime.combiner.class");
        confKeys.add("tez.runtime.shuffle.use.async.http");
        confKeys.add("tez.runtime.shuffle.parallel.copies");
        confKeys.add("tez.runtime.shuffle.fetch.failures.limit");
        confKeys.add("tez.runtime.shuffle.fetch.max.task.output.at.once");
        confKeys.add("tez.runtime.shuffle.notify.readerror");
        confKeys.add("tez.runtime.shuffle.connect.timeout");
        confKeys.add("tez.runtime.shuffle.keep-alive.enabled");
        confKeys.add("tez.runtime.shuffle.keep-alive.max.connections");
        confKeys.add("tez.runtime.shuffle.read.timeout");
        confKeys.add("tez.runtime.shuffle.buffersize");
        confKeys.add("tez.runtime.shuffle.ssl.enable");
        confKeys.add("tez.runtime.shuffle.fetch.buffer.percent");
        confKeys.add("tez.runtime.shuffle.memory.limit.percent");
        confKeys.add("tez.runtime.shuffle.merge.percent");
        confKeys.add("tez.runtime.shuffle.memory-to-memory.segments");
        confKeys.add("tez.runtime.shuffle.memory-to-memory.enable");
        confKeys.add("tez.runtime.task.input.post-merge.buffer.percent");
        confKeys.add("tez.runtime.group.comparator.class");
        confKeys.add("tez.runtime.key.comparator.class");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.key.secondary.comparator.class");
        confKeys.add("tez.runtime.optimize.local.fetch");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
    }

    private static class OrderedGroupedKeyValuesReader
    extends KeyValuesReader {
        private final ValuesIterator valuesIter;

        OrderedGroupedKeyValuesReader(ValuesIterator valuesIter) {
            this.valuesIter = valuesIter;
        }

        @Override
        public boolean next() throws IOException {
            return this.valuesIter.moveToNext();
        }

        @Override
        public Object getCurrentKey() throws IOException {
            return this.valuesIter.getKey();
        }

        @Override
        public Iterable<Object> getCurrentValues() throws IOException {
            return this.valuesIter.getValues();
        }
    }
}

