/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.api.TezRuntimeConfiguration;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.conf.BaseConfigBuilder;
import org.apache.tez.runtime.library.conf.HadoopKeyValuesBasedBaseEdgeConfig;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UnorderedPartitionedKVOutputConfig {
    @InterfaceAudience.Private
    @VisibleForTesting
    Configuration conf;

    @InterfaceAudience.Private
    @VisibleForTesting
    UnorderedPartitionedKVOutputConfig() {
    }

    private UnorderedPartitionedKVOutputConfig(Configuration conf) {
        this.conf = conf;
    }

    public UserPayload toUserPayload() {
        try {
            return TezUtils.createUserPayloadFromConf((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @InterfaceAudience.Private
    public void fromUserPayload(UserPayload payload) {
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)payload);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @InterfaceAudience.Private
    String toHistoryText() {
        if (this.conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
            return TezUtils.convertToHistoryText((Configuration)this.conf);
        }
        return null;
    }

    public static Builder newBuilder(String keyClass, String valClass, String partitionerClassName) {
        return UnorderedPartitionedKVOutputConfig.newBuilder(keyClass, valClass, partitionerClassName, null);
    }

    public static Builder newBuilder(String keyClass, String valClass, String partitionerClassName, Map<String, String> partitionerConf) {
        return new Builder(keyClass, valClass, partitionerClassName, partitionerConf);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder
    implements SpecificConfigBuilder<Builder> {
        private final Configuration conf = new Configuration(false);

        @InterfaceAudience.Private
        Builder(String keyClassName, String valueClassName, String partitionerClassName, Map<String, String> partitionerConf) {
            this();
            Preconditions.checkNotNull((Object)keyClassName, (Object)"Key class name cannot be null");
            Preconditions.checkNotNull((Object)valueClassName, (Object)"Value class name cannot be null");
            Preconditions.checkNotNull((Object)partitionerClassName, (Object)"Partitioner class name cannot be null");
            this.setKeyClassName(keyClassName);
            this.setValueClassName(valueClassName);
            this.setPartitioner(partitionerClassName, partitionerConf);
        }

        @InterfaceAudience.Private
        Builder() {
            Map<String, String> tezDefaults = ConfigUtils.extractConfigurationMap(TezRuntimeConfiguration.getTezRuntimeConfigDefaults(), UnorderedPartitionedKVOutput.getConfigurationKeySet());
            ConfigUtils.addConfigMapToConfiguration(this.conf, tezDefaults);
            ConfigUtils.addConfigMapToConfiguration(this.conf, TezRuntimeConfiguration.getOtherConfigDefaults());
        }

        @InterfaceAudience.Private
        Builder setKeyClassName(String keyClassName) {
            Preconditions.checkNotNull((Object)keyClassName, (Object)"Key class name cannot be null");
            this.conf.set("tez.runtime.key.class", keyClassName);
            return this;
        }

        @InterfaceAudience.Private
        Builder setValueClassName(String valueClassName) {
            Preconditions.checkNotNull((Object)valueClassName, (Object)"Value class name cannot be null");
            this.conf.set("tez.runtime.value.class", valueClassName);
            return this;
        }

        @InterfaceAudience.Private
        Builder setPartitioner(String partitionerClassName, Map<String, String> partitionerConf) {
            Preconditions.checkNotNull((Object)partitionerClassName, (Object)"Partitioner class name cannot be null");
            this.conf.set("tez.runtime.partitioner.class", partitionerClassName);
            if (partitionerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, partitionerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        @Override
        public Builder setAvailableBufferSize(int availableBufferSize) {
            this.conf.setInt("tez.runtime.unordered.output.buffer.size-mb", availableBufferSize);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
            if (ConfigUtils.doesKeyQualify(key, Lists.newArrayList((Object[])new Set[]{UnorderedPartitionedKVOutput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes())) {
                if (value == null) {
                    this.conf.unset(key);
                } else {
                    this.conf.set(key, value);
                }
            }
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(Map<String, String> confMap) {
            Preconditions.checkNotNull(confMap, (Object)"ConfMap cannot be null");
            Map<String, String> map = ConfigUtils.extractConfigurationMap(confMap, (List<Set<String>>)Lists.newArrayList((Object[])new Set[]{UnorderedPartitionedKVOutput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes());
            ConfigUtils.addConfigMapToConfiguration(this.conf, map);
            return this;
        }

        @Override
        public Builder setFromConfiguration(Configuration conf) {
            Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration cannot be null");
            Map<String, String> map = ConfigUtils.extractConfigurationMap(conf, (List<Set<String>>)Lists.newArrayList((Object[])new Set[]{UnorderedPartitionedKVOutput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes());
            ConfigUtils.addConfigMapToConfiguration(this.conf, map);
            return this;
        }

        public Builder setCompression(boolean enabled, @Nullable String compressionCodec, @Nullable Map<String, String> codecConf) {
            this.conf.setBoolean("tez.runtime.compress", enabled);
            if (enabled && compressionCodec != null) {
                this.conf.set("tez.runtime.compress.codec", compressionCodec);
            }
            if (codecConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, codecConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public Builder setKeySerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            Preconditions.checkArgument((serializationClassName != null ? 1 : 0) != 0, (Object)"serializationClassName cannot be null");
            this.conf.set("io.serializations", serializationClassName + "," + this.conf.get("io.serializations"));
            if (serializerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, serializerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public Builder setValueSerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            Preconditions.checkArgument((serializationClassName != null ? 1 : 0) != 0, (Object)"serializationClassName cannot be null");
            this.conf.set("io.serializations", serializationClassName + "," + this.conf.get("io.serializations"));
            if (serializerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, serializerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public UnorderedPartitionedKVOutputConfig build() {
            return new UnorderedPartitionedKVOutputConfig(this.conf);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class SpecificBuilder<E extends HadoopKeyValuesBasedBaseEdgeConfig.Builder>
    implements SpecificConfigBuilder<SpecificBuilder> {
        private final E edgeBuilder;
        private final Builder builder;

        SpecificBuilder(E edgeBuilder, Builder builder) {
            this.edgeBuilder = edgeBuilder;
            this.builder = builder;
        }

        @Override
        public SpecificBuilder<E> setAvailableBufferSize(int availableBufferSize) {
            this.builder.setAvailableBufferSize(availableBufferSize);
            return this;
        }

        @Override
        public SpecificBuilder<E> setAdditionalConfiguration(String key, String value) {
            this.builder.setAdditionalConfiguration(key, value);
            return this;
        }

        @Override
        public SpecificBuilder<E> setAdditionalConfiguration(Map<String, String> confMap) {
            this.builder.setAdditionalConfiguration((Map)confMap);
            return this;
        }

        @Override
        public SpecificBuilder<E> setFromConfiguration(Configuration conf) {
            this.builder.setFromConfiguration(conf);
            return this;
        }

        public E done() {
            return this.edgeBuilder;
        }
    }

    @InterfaceAudience.Private
    public static interface SpecificConfigBuilder<T>
    extends BaseConfigBuilder<T> {
        public T setAvailableBufferSize(int var1);
    }
}

