/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.api.TezRuntimeConfiguration;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.conf.BaseConfigBuilder;
import org.apache.tez.runtime.library.conf.HadoopKeyValuesBasedBaseEdgeConfig;
import org.apache.tez.runtime.library.input.OrderedGroupedInputLegacy;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedGroupedKVInputConfig {
    @InterfaceAudience.Private
    @VisibleForTesting
    Configuration conf;
    private String inputClassName;

    @InterfaceAudience.Private
    @VisibleForTesting
    OrderedGroupedKVInputConfig() {
    }

    private OrderedGroupedKVInputConfig(Configuration conf, boolean useLegacyInput) {
        this.conf = conf;
        this.inputClassName = useLegacyInput ? OrderedGroupedInputLegacy.class.getName() : OrderedGroupedKVInput.class.getName();
    }

    public UserPayload toUserPayload() {
        try {
            return TezUtils.createUserPayloadFromConf((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @InterfaceAudience.Private
    public void fromUserPayload(UserPayload payload) {
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)payload);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getInputClassName() {
        return this.inputClassName;
    }

    public static Builder newBuilder(String keyClass, String valueClass) {
        return new Builder(keyClass, valueClass);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder
    implements SpecificConfigBuilder<Builder> {
        private final Configuration conf = new Configuration(false);
        private boolean useLegacyInput = false;

        @InterfaceAudience.Private
        Builder(String keyClassName, String valueClassName) {
            this();
            Preconditions.checkNotNull((Object)keyClassName, (Object)"Key class name cannot be null");
            Preconditions.checkNotNull((Object)valueClassName, (Object)"Value class name cannot be null");
            this.setKeyClassName(keyClassName);
            this.setValueClassName(valueClassName);
        }

        @InterfaceAudience.Private
        Builder() {
            Map<String, String> tezDefaults = ConfigUtils.extractConfigurationMap(TezRuntimeConfiguration.getTezRuntimeConfigDefaults(), OrderedGroupedKVInput.getConfigurationKeySet());
            ConfigUtils.addConfigMapToConfiguration(this.conf, tezDefaults);
            ConfigUtils.addConfigMapToConfiguration(this.conf, TezRuntimeConfiguration.getOtherConfigDefaults());
        }

        @InterfaceAudience.Private
        Builder setKeyClassName(String keyClassName) {
            Preconditions.checkNotNull((Object)keyClassName, (Object)"Key class name cannot be null");
            this.conf.set("tez.runtime.key.class", keyClassName);
            return this;
        }

        @InterfaceAudience.Private
        Builder setValueClassName(String valueClassName) {
            Preconditions.checkNotNull((Object)valueClassName, (Object)"Value class name cannot be null");
            this.conf.set("tez.runtime.value.class", valueClassName);
            return this;
        }

        @Override
        public Builder useLegacyInput() {
            this.useLegacyInput = true;
            return this;
        }

        @Override
        public Builder setShuffleBufferFraction(float shuffleBufferFraction) {
            this.conf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", shuffleBufferFraction);
            return this;
        }

        @Override
        public Builder setPostMergeBufferFraction(float postMergeBufferFraction) {
            this.conf.setFloat("tez.runtime.task.input.post-merge.buffer.percent", postMergeBufferFraction);
            return this;
        }

        @Override
        public Builder setMaxSingleMemorySegmentFraction(float maxSingleSegmentFraction) {
            this.conf.setFloat("tez.runtime.shuffle.memory.limit.percent", maxSingleSegmentFraction);
            return this;
        }

        @Override
        public Builder setMemToMemMerger(boolean enable) {
            this.conf.setBoolean("tez.runtime.shuffle.memory-to-memory.enable", enable);
            return this;
        }

        @Override
        public Builder setMergeFraction(float mergeFraction) {
            this.conf.setFloat("tez.runtime.shuffle.merge.percent", mergeFraction);
            return this;
        }

        @Override
        public Builder setCombiner(String combinerClassName) {
            return this.setCombiner(combinerClassName, (Map)null);
        }

        @Override
        public Builder setCombiner(String combinerClassName, Map<String, String> combinerConf) {
            this.conf.set("tez.runtime.combiner.class", combinerClassName);
            if (combinerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, combinerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public Builder setKeyComparatorClass(String comparatorClassName) {
            return this.setKeyComparatorClass(comparatorClassName, null);
        }

        public Builder setKeyComparatorClass(String comparatorClassName, @Nullable Map<String, String> comparatorConf) {
            Preconditions.checkNotNull((Object)comparatorClassName, (Object)"Comparator class name cannot be null");
            this.conf.set("tez.runtime.key.comparator.class", comparatorClassName);
            if (comparatorConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, comparatorConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(String key, String value) {
            Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
            if (ConfigUtils.doesKeyQualify(key, Lists.newArrayList((Object[])new Set[]{OrderedGroupedKVInput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes())) {
                if (value == null) {
                    this.conf.unset(key);
                } else {
                    this.conf.set(key, value);
                }
            }
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(Map<String, String> confMap) {
            Preconditions.checkNotNull(confMap, (Object)"ConfMap cannot be null");
            Map<String, String> map = ConfigUtils.extractConfigurationMap(confMap, (List<Set<String>>)Lists.newArrayList((Object[])new Set[]{OrderedGroupedKVInput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes());
            ConfigUtils.addConfigMapToConfiguration(this.conf, map);
            return this;
        }

        @Override
        public Builder setFromConfiguration(Configuration conf) {
            Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration cannot be null");
            Map<String, String> map = ConfigUtils.extractConfigurationMap(conf, (List<Set<String>>)Lists.newArrayList((Object[])new Set[]{OrderedGroupedKVInput.getConfigurationKeySet(), TezRuntimeConfiguration.getRuntimeAdditionalConfigKeySet()}), TezRuntimeConfiguration.getAllowedPrefixes());
            ConfigUtils.addConfigMapToConfiguration(this.conf, map);
            return this;
        }

        public Builder setCompression(boolean enabled, @Nullable String compressionCodec, @Nullable Map<String, String> codecConf) {
            this.conf.setBoolean("tez.runtime.compress", enabled);
            if (enabled && compressionCodec != null) {
                this.conf.set("tez.runtime.compress.codec", compressionCodec);
            }
            if (codecConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, codecConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public Builder setKeySerializationClass(String serializationClassName, String comparatorClassName, @Nullable Map<String, String> serializerConf) {
            Preconditions.checkArgument((serializationClassName != null ? 1 : 0) != 0, (Object)"serializationClassName cannot be null");
            Preconditions.checkArgument((comparatorClassName != null ? 1 : 0) != 0, (Object)"comparator cannot be null");
            this.conf.set("io.serializations", serializationClassName + "," + this.conf.get("io.serializations"));
            this.setKeyComparatorClass(comparatorClassName, null);
            if (serializerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, serializerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public Builder setValueSerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            Preconditions.checkArgument((serializationClassName != null ? 1 : 0) != 0, (Object)"serializationClassName cannot be null");
            this.conf.set("io.serializations", serializationClassName + "," + this.conf.get("io.serializations"));
            if (serializerConf != null) {
                ConfigUtils.mergeConfsWithExclusions(this.conf, serializerConf, TezRuntimeConfiguration.getRuntimeConfigKeySet());
            }
            return this;
        }

        public OrderedGroupedKVInputConfig build() {
            return new OrderedGroupedKVInputConfig(this.conf, this.useLegacyInput);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class SpecificBuilder<E extends HadoopKeyValuesBasedBaseEdgeConfig.Builder>
    implements SpecificConfigBuilder<SpecificBuilder> {
        private final E edgeBuilder;
        private final Builder builder;

        @InterfaceAudience.Private
        SpecificBuilder(E edgeBuilder, Builder builder) {
            this.edgeBuilder = edgeBuilder;
            this.builder = builder;
        }

        @Override
        public SpecificBuilder<E> useLegacyInput() {
            this.builder.useLegacyInput();
            return this;
        }

        @Override
        public SpecificBuilder<E> setShuffleBufferFraction(float shuffleBufferFraction) {
            this.builder.setShuffleBufferFraction(shuffleBufferFraction);
            return this;
        }

        @Override
        public SpecificBuilder<E> setPostMergeBufferFraction(float postMergeBufferFraction) {
            this.builder.setPostMergeBufferFraction(postMergeBufferFraction);
            return this;
        }

        @Override
        public SpecificBuilder<E> setMaxSingleMemorySegmentFraction(float maxSingleSegmentFraction) {
            this.builder.setMaxSingleMemorySegmentFraction(maxSingleSegmentFraction);
            return this;
        }

        @Override
        public SpecificBuilder<E> setMemToMemMerger(boolean enable) {
            this.builder.setMemToMemMerger(enable);
            return this;
        }

        @Override
        public SpecificBuilder<E> setMergeFraction(float mergeFraction) {
            this.builder.setMergeFraction(mergeFraction);
            return this;
        }

        @Override
        public SpecificBuilder<E> setCombiner(String combinerClassName) {
            return this.setCombiner(combinerClassName, (Map)null);
        }

        @Override
        public SpecificBuilder<E> setCombiner(String combinerClassName, Map<String, String> combinerConf) {
            this.builder.setCombiner(combinerClassName, (Map)combinerConf);
            return this;
        }

        @Override
        public SpecificBuilder setAdditionalConfiguration(String key, String value) {
            this.builder.setAdditionalConfiguration(key, value);
            return this;
        }

        @Override
        public SpecificBuilder setAdditionalConfiguration(Map<String, String> confMap) {
            this.builder.setAdditionalConfiguration((Map)confMap);
            return this;
        }

        @Override
        public SpecificBuilder setFromConfiguration(Configuration conf) {
            this.builder.setFromConfiguration(conf);
            return this;
        }

        public E done() {
            return this.edgeBuilder;
        }
    }

    @InterfaceAudience.Private
    public static interface SpecificConfigBuilder<T>
    extends BaseConfigBuilder<T> {
        public T useLegacyInput();

        public T setShuffleBufferFraction(float var1);

        public T setPostMergeBufferFraction(float var1);

        public T setMaxSingleMemorySegmentFraction(float var1);

        public T setMemToMemMerger(boolean var1);

        public T setMergeFraction(float var1);

        public T setCombiner(String var1);

        public T setCombiner(String var1, @Nullable Map<String, String> var2);
    }
}

