/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

public abstract class TezTaskContextImpl
implements TezTaskContext {
    private static final AtomicInteger ID_GEN = new AtomicInteger(10000);
    private final Configuration conf;
    protected final String taskVertexName;
    protected final TezTaskAttemptID taskAttemptID;
    private final TezCounters counters;
    private String[] workDirs;
    private String uniqueIdentifier;
    protected final RuntimeTask runtimeTask;
    protected final TezUmbilical tezUmbilical;
    private final Map<String, ByteBuffer> serviceConsumerMetadata;
    private final int appAttemptNumber;
    private final Map<String, String> auxServiceEnv;
    protected final MemoryDistributor initialMemoryDistributor;
    protected final TezEntityDescriptor descriptor;
    private final String dagName;

    @InterfaceAudience.Private
    public TezTaskContextImpl(Configuration conf, int appAttemptNumber, String dagName, String taskVertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, RuntimeTask runtimeTask, TezUmbilical tezUmbilical, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, TezEntityDescriptor descriptor) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        Preconditions.checkNotNull((Object)dagName, (Object)"dagName is null");
        Preconditions.checkNotNull((Object)taskVertexName, (Object)"taskVertexName is null");
        Preconditions.checkNotNull((Object)taskAttemptID, (Object)"taskAttemptId is null");
        Preconditions.checkNotNull((Object)counters, (Object)"counters is null");
        Preconditions.checkNotNull((Object)runtimeTask, (Object)"runtimeTask is null");
        Preconditions.checkNotNull(auxServiceEnv, (Object)"auxServiceEnv is null");
        Preconditions.checkNotNull((Object)memDist, (Object)"memDist is null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor is null");
        this.conf = conf;
        this.dagName = dagName;
        this.taskVertexName = taskVertexName;
        this.taskAttemptID = taskAttemptID;
        this.counters = counters;
        this.workDirs = this.conf.getStrings("tez.runtime.local.dirs");
        this.runtimeTask = runtimeTask;
        this.tezUmbilical = tezUmbilical;
        this.serviceConsumerMetadata = serviceConsumerMetadata;
        this.appAttemptNumber = appAttemptNumber;
        this.auxServiceEnv = auxServiceEnv;
        this.uniqueIdentifier = String.format("%s_%05d", taskAttemptID.toString(), this.generateId());
        this.initialMemoryDistributor = memDist;
        this.descriptor = descriptor;
    }

    public ApplicationId getApplicationId() {
        return this.taskAttemptID.getTaskID().getVertexID().getDAGId().getApplicationId();
    }

    public int getTaskIndex() {
        return this.taskAttemptID.getTaskID().getId();
    }

    public int getDAGAttemptNumber() {
        return this.appAttemptNumber;
    }

    public int getTaskAttemptNumber() {
        return this.taskAttemptID.getId();
    }

    public String getDAGName() {
        return this.dagName;
    }

    public String getTaskVertexName() {
        return this.taskVertexName;
    }

    public int getTaskVertexIndex() {
        return this.taskAttemptID.getTaskID().getVertexID().getId();
    }

    public TezCounters getCounters() {
        return this.counters;
    }

    public String[] getWorkDirs() {
        return Arrays.copyOf(this.workDirs, this.workDirs.length);
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public ByteBuffer getServiceConsumerMetaData(String serviceName) {
        return (ByteBuffer)this.serviceConsumerMetadata.get(serviceName).asReadOnlyBuffer().rewind();
    }

    public ByteBuffer getServiceProviderMetaData(String serviceName) {
        return AuxiliaryServiceHelper.getServiceDataFromEnv((String)serviceName, this.auxServiceEnv);
    }

    public void requestInitialMemory(long size, MemoryUpdateCallback callbackHandler) {
        if (callbackHandler == null) {
            Preconditions.checkArgument((size == 0L ? 1 : 0) != 0, (Object)"A Null callback handler can only be used with a request size of 0");
            callbackHandler = new MemoryUpdateCallback(){

                public void memoryAssigned(long assignedSize) {
                }
            };
        }
        this.initialMemoryDistributor.requestMemory(size, callbackHandler, this, this.descriptor);
    }

    public long getTotalMemoryAvailableToTask() {
        return Runtime.getRuntime().maxMemory();
    }

    protected void signalFatalError(Throwable t, String message, EventMetaData sourceInfo) {
        this.runtimeTask.setFatalError(t, message);
        String diagnostics = t != null && message != null ? "exceptionThrown=" + StringUtils.stringifyException((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "exceptionThrown=" + StringUtils.stringifyException((Throwable)t) : " errorMessage=" + message));
        this.tezUmbilical.signalFatalError(this.taskAttemptID, diagnostics, sourceInfo);
    }

    private int generateId() {
        return ID_GEN.incrementAndGet();
    }
}

