/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.objectregistry;

import com.google.inject.Singleton;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tez.runtime.common.objectregistry.ObjectLifeCycle;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistry;

@Singleton
public class ObjectRegistryImpl
implements ObjectRegistry {
    private Map<String, Map.Entry<Object, ObjectLifeCycle>> objectCache = new HashMap<String, Map.Entry<Object, ObjectLifeCycle>>();

    public synchronized Object add(ObjectLifeCycle lifeCycle, String key, Object value) {
        Map.Entry oldEntry = this.objectCache.put(key, new AbstractMap.SimpleImmutableEntry<Object, ObjectLifeCycle>(value, lifeCycle));
        return oldEntry != null ? oldEntry.getKey() : null;
    }

    public synchronized Object get(String key) {
        Map.Entry<Object, ObjectLifeCycle> entry = this.objectCache.get(key);
        return entry != null ? entry.getKey() : null;
    }

    public synchronized boolean delete(String key) {
        return null != this.objectCache.remove(key);
    }

    public synchronized void clearCache(ObjectLifeCycle lifeCycle) {
        Iterator<Map.Entry<String, Map.Entry<Object, ObjectLifeCycle>>> it = this.objectCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map.Entry<Object, ObjectLifeCycle>> entry = it.next();
            if (!entry.getValue().getValue().equals((Object)lifeCycle)) continue;
            it.remove();
        }
    }
}

