/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor.reduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.ProgressHelper;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.processor.MRTask;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.input.OrderedGroupedInputLegacy;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReduceProcessor
extends MRTask {
    private static final Logger LOG = LoggerFactory.getLogger(ReduceProcessor.class);
    private Counters.Counter reduceInputKeyCounter;
    private Counters.Counter reduceInputValueCounter;
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;
    private ProgressHelper progressHelper;

    public ReduceProcessor(ProcessorContext processorContext) {
        super(processorContext, false);
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws IOException {
        if (this.progressHelper != null) {
            this.progressHelper.shutDownProgressTaskService();
        }
    }

    public void run(Map<String, LogicalInput> _inputs, Map<String, LogicalOutput> _outputs) throws Exception {
        this.inputs = _inputs;
        this.outputs = _outputs;
        this.progressHelper = new ProgressHelper(this.inputs, this.processorContext, ((Object)((Object)this)).getClass().getSimpleName());
        LOG.info("Running reduce: " + this.processorContext.getUniqueIdentifier());
        if (_outputs.size() <= 0 || _outputs.size() > 1) {
            throw new IOException("Invalid number of _outputs, outputCount=" + _outputs.size());
        }
        if (_inputs.size() <= 0 || _inputs.size() > 1) {
            throw new IOException("Invalid number of _inputs, inputCount=" + _inputs.size());
        }
        LogicalInput in = _inputs.values().iterator().next();
        in.start();
        LinkedList<LogicalInput> pendingInputs = new LinkedList<LogicalInput>();
        pendingInputs.add(in);
        this.processorContext.waitForAllInputsReady(pendingInputs);
        LOG.info("Input is ready for consumption. Starting Output");
        LogicalOutput out = _outputs.values().iterator().next();
        out.start();
        this.initTask(out);
        this.progressHelper.scheduleProgressTaskService(0L, 100L);
        this.statusUpdate();
        Class keyClass = ConfigUtils.getIntermediateInputKeyClass((Configuration)this.jobConf);
        Class valueClass = ConfigUtils.getIntermediateInputValueClass((Configuration)this.jobConf);
        LOG.info("Using keyClass: " + keyClass);
        LOG.info("Using valueClass: " + valueClass);
        RawComparator comparator = ConfigUtils.getInputKeySecondaryGroupingComparator((Configuration)this.jobConf);
        LOG.info("Using comparator: " + comparator);
        this.reduceInputKeyCounter = this.mrReporter.getCounter((Enum<?>)TaskCounter.REDUCE_INPUT_GROUPS);
        this.reduceInputValueCounter = this.mrReporter.getCounter((Enum<?>)TaskCounter.REDUCE_INPUT_RECORDS);
        if (!(in instanceof OrderedGroupedInputLegacy)) {
            throw new IOException("Illegal input to reduce: " + in.getClass());
        }
        OrderedGroupedInputLegacy shuffleInput = (OrderedGroupedInputLegacy)in;
        KeyValuesReader kvReader = shuffleInput.getReader();
        KeyValueWriter kvWriter = null;
        if (out instanceof MROutputLegacy) {
            kvWriter = ((MROutputLegacy)out).getWriter();
        } else if (out instanceof OrderedPartitionedKVOutput) {
            kvWriter = ((OrderedPartitionedKVOutput)out).getWriter();
        } else {
            throw new IOException("Illegal output to reduce: " + in.getClass());
        }
        if (this.useNewApi) {
            try {
                this.runNewReducer(this.jobConf, this.mrReporter, shuffleInput, comparator, keyClass, valueClass, kvWriter);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        } else {
            this.runOldReducer(this.jobConf, this.mrReporter, kvReader, comparator, keyClass, valueClass, kvWriter);
        }
        this.done();
    }

    void runOldReducer(JobConf job, MRTaskReporter reporter, KeyValuesReader input, RawComparator comparator, Class keyClass, Class valueClass, final KeyValueWriter output) throws IOException, InterruptedException {
        Reducer reducer = (Reducer)ReflectionUtils.newInstance((Class)job.getReducerClass(), (Configuration)job);
        OutputCollector collector = new OutputCollector(){

            public void collect(Object key, Object value) throws IOException {
                output.write(key, value);
            }
        };
        try {
            ReduceValuesIterator values = new ReduceValuesIterator(input, (Progressable)reporter, this.reduceInputValueCounter);
            values.informReduceProgress();
            while (values.more()) {
                this.reduceInputKeyCounter.increment(1L);
                reducer.reduce(values.getKey(), values, collector, (Reporter)reporter);
                values.informReduceProgress();
            }
            reporter.setProgress(1.0f);
            reducer.close();
        }
        catch (IOException ioe) {
            try {
                reducer.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw ioe;
        }
    }

    void runNewReducer(JobConf job, final MRTaskReporter reporter, OrderedGroupedInputLegacy input, RawComparator comparator, Class keyClass, Class valueClass, final KeyValueWriter out) throws IOException, InterruptedException, ClassNotFoundException, TezException {
        TaskAttemptContext taskContext = this.getTaskAttemptContext();
        org.apache.hadoop.mapreduce.Reducer reducer = (org.apache.hadoop.mapreduce.Reducer)ReflectionUtils.newInstance((Class)taskContext.getReducerClass(), (Configuration)job);
        final TezRawKeyValueIterator rawIter = input.getIterator();
        TezRawKeyValueIterator rIter = new TezRawKeyValueIterator(){

            public void close() throws IOException {
                rawIter.close();
            }

            public DataInputBuffer getKey() throws IOException {
                return rawIter.getKey();
            }

            public Progress getProgress() {
                return rawIter.getProgress();
            }

            public boolean isSameKey() throws IOException {
                return rawIter.isSameKey();
            }

            public DataInputBuffer getValue() throws IOException {
                return rawIter.getValue();
            }

            public boolean next() throws IOException {
                boolean ret = rawIter.next();
                reporter.setProgress(rawIter.getProgress().getProgress());
                return ret;
            }
        };
        RecordWriter trackedRW = new RecordWriter(){

            public void write(Object key, Object value) throws IOException, InterruptedException {
                out.write(key, value);
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            }
        };
        Reducer.Context reducerContext = ReduceProcessor.createReduceContext(reducer, (Configuration)job, this.taskAttemptId, rIter, (Counter)this.reduceInputKeyCounter, (Counter)this.reduceInputValueCounter, trackedRW, this.committer, reporter, comparator, keyClass, valueClass);
        reducer.run(reducerContext);
        reporter.setProgress(1.0f);
        trackedRW.close((TaskAttemptContext)reducerContext);
    }

    @Override
    public void localizeConfiguration(JobConf jobConf) throws IOException, InterruptedException {
        super.localizeConfiguration(jobConf);
        jobConf.setBoolean("mapreduce.task.ismap", false);
    }

    private static class ReduceValuesIterator<KEY, VALUE>
    implements Iterator<VALUE> {
        private Counters.Counter reduceInputValueCounter;
        private KeyValuesReader in;
        private Progressable reporter;
        private Object currentKey;
        private Iterator<Object> currentValues;

        public ReduceValuesIterator(KeyValuesReader in, Progressable reporter, Counters.Counter reduceInputValueCounter) throws IOException {
            this.reduceInputValueCounter = reduceInputValueCounter;
            this.in = in;
            this.reporter = reporter;
        }

        public boolean more() throws IOException {
            boolean more = this.in.next();
            if (more) {
                this.currentKey = this.in.getCurrentKey();
                this.currentValues = this.in.getCurrentValues().iterator();
            } else {
                this.currentKey = null;
                this.currentValues = null;
            }
            return more;
        }

        public KEY getKey() throws IOException {
            return (KEY)this.currentKey;
        }

        public void informReduceProgress() {
            this.reporter.progress();
        }

        @Override
        public boolean hasNext() {
            return this.currentValues.hasNext();
        }

        @Override
        public VALUE next() {
            this.reduceInputValueCounter.increment(1L);
            return (VALUE)this.currentValues.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

