/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.common.MRInputAMSplitGenerator;
import org.apache.tez.mapreduce.common.MRInputSplitDistributor;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.base.MRInputBase;
import org.apache.tez.mapreduce.lib.MRInputUtils;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.mapreduce.lib.MRReaderMapReduce;
import org.apache.tez.mapreduce.lib.MRReaderMapred;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class MRInput
extends MRInputBase {
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_DAG_INDEX = "tez.mapreduce.dag.index";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_DAG_NAME = "tez.mapreduce.dag.name";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_VERTEX_INDEX = "tez.mapreduce.vertex.index";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_VERTEX_NAME = "tez.mapreduce.vertex.name";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_TASK_INDEX = "tez.mapreduce.task.index";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_TASK_ATTEMPT_INDEX = "tez.mapreduce.task.attempt.index";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_INPUT_INDEX = "tez.mapreduce.input.index";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_INPUT_NAME = "tez.mapreduce.input.name";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_APPLICATION_ID = "tez.mapreduce.application.id";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_UNIQUE_IDENTIFIER = "tez.mapreduce.unique.identifier";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_DAG_ATTEMPT_NUMBER = "tez.mapreduce.dag.attempt.number";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_DAG_ID = "tez.mapreduce.dag.id";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_VERTEX_ID = "tez.mapreduce.vertex.id";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_TASK_ID = "tez.mapreduce.task.id";
    @InterfaceAudience.Private
    public static final String TEZ_MAPREDUCE_TASK_ATTEMPT_ID = "tez.mapreduce.task.attempt.id";
    private static final Logger LOG = LoggerFactory.getLogger(MRInput.class);
    private final ReentrantLock rrLock = new ReentrantLock();
    private final Condition rrInited = this.rrLock.newCondition();
    private volatile boolean eventReceived = false;
    private boolean readerCreated = false;
    protected MRReader mrReader;
    protected JobSplit.TaskSplitIndex splitMetaInfo = new JobSplit.TaskSplitIndex();
    @InterfaceAudience.Private
    volatile boolean splitInfoViaEvents;

    public static MRInputConfigBuilder createConfigBuilder(Configuration conf, @Nullable Class<?> inputFormat) {
        return new MRInputConfigBuilder(conf, inputFormat);
    }

    public static MRInputConfigBuilder createConfigBuilder(Configuration conf, @Nullable Class<?> inputFormat, @Nullable String inputPaths) {
        MRInputConfigBuilder configurer = new MRInputConfigBuilder(conf, inputFormat);
        if (inputPaths != null) {
            return configurer.setInputPaths(inputPaths);
        }
        return configurer;
    }

    public MRInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    @Override
    public List<Event> initialize() throws IOException {
        super.initialize();
        this.getContext().inputIsReady();
        this.splitInfoViaEvents = this.jobConf.getBoolean("mapreduce.tez.splits.via.events", true);
        LOG.info(this.getContext().getSourceVertexName() + " using newmapreduce API=" + this.useNewApi + ", split via event=" + this.splitInfoViaEvents + ", numPhysicalInputs=" + this.getNumPhysicalInputs());
        this.initializeInternal();
        return null;
    }

    public void start() {
        Preconditions.checkState((this.getNumPhysicalInputs() == 0 || this.getNumPhysicalInputs() == 1 ? 1 : 0) != 0, (Object)"Expecting 0 or 1 physical input for MRInput");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void initializeInternal() throws IOException {
        block9: {
            this.rrLock.lock();
            try {
                if (this.splitInfoViaEvents) {
                    this.mrReader = this.useNewApi ? new MRReaderMapReduce(this.jobConf, this.getContext().getCounters(), this.inputRecordCounter, this.getContext().getApplicationId().getClusterTimestamp(), this.getContext().getTaskVertexIndex(), this.getContext().getApplicationId().getId(), this.getContext().getTaskIndex(), this.getContext().getTaskAttemptNumber(), this.getContext()) : new MRReaderMapred(this.jobConf, this.getContext().getCounters(), this.inputRecordCounter, this.getContext());
                    break block9;
                }
                JobSplit.TaskSplitMetaInfo[] allMetaInfo = MRInputUtils.readSplits((Configuration)this.jobConf);
                JobSplit.TaskSplitMetaInfo thisTaskMetaInfo = allMetaInfo[this.getContext().getTaskIndex()];
                JobSplit.TaskSplitIndex splitMetaInfo = new JobSplit.TaskSplitIndex(thisTaskMetaInfo.getSplitLocation(), thisTaskMetaInfo.getStartOffset());
                long splitLength = -1L;
                if (this.useNewApi) {
                    org.apache.hadoop.mapreduce.InputSplit newInputSplit = MRInputUtils.getNewSplitDetailsFromDisk(splitMetaInfo, this.jobConf, this.getContext().getCounters().findCounter((Enum)TaskCounter.SPLIT_RAW_BYTES));
                    try {
                        splitLength = newInputSplit.getLength();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Got interrupted while reading split length: ", (Throwable)e);
                    }
                    this.mrReader = new MRReaderMapReduce(this.jobConf, newInputSplit, this.getContext().getCounters(), this.inputRecordCounter, this.getContext().getApplicationId().getClusterTimestamp(), this.getContext().getTaskVertexIndex(), this.getContext().getApplicationId().getId(), this.getContext().getTaskIndex(), this.getContext().getTaskAttemptNumber(), this.getContext());
                } else {
                    InputSplit oldInputSplit = MRInputUtils.getOldSplitDetailsFromDisk(splitMetaInfo, this.jobConf, this.getContext().getCounters().findCounter((Enum)TaskCounter.SPLIT_RAW_BYTES));
                    splitLength = oldInputSplit.getLength();
                    this.mrReader = new MRReaderMapred(this.jobConf, oldInputSplit, this.getContext().getCounters(), this.inputRecordCounter, this.getContext());
                }
                if (splitLength != -1L) {
                    this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_SPLIT_LENGTH_BYTES).increment(splitLength);
                }
            }
            finally {
                this.rrLock.unlock();
            }
        }
        LOG.info("Initialized MRInput: " + this.getContext().getSourceVertexName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueReader getReader() throws IOException {
        Preconditions.checkState((!this.readerCreated ? 1 : 0) != 0, (Object)"Only a single instance of record reader can be created for this input.");
        this.readerCreated = true;
        if (this.getNumPhysicalInputs() == 0) {
            return new KeyValueReader(){

                public boolean next() throws IOException {
                    MRInput.this.getContext().notifyProgress();
                    return false;
                }

                public Object getCurrentKey() throws IOException {
                    return null;
                }

                public Object getCurrentValue() throws IOException {
                    return null;
                }
            };
        }
        this.rrLock.lock();
        try {
            if (!this.mrReader.isSetup()) {
                this.checkAndAwaitRecordReaderInitialization();
            }
        }
        finally {
            this.rrLock.unlock();
        }
        return this.mrReader;
    }

    public void handleEvents(List<Event> inputEvents) throws Exception {
        if (this.getNumPhysicalInputs() == 0) {
            throw new IllegalStateException("Unexpected event. MRInput has been setup to receive 0 events");
        }
        if (this.eventReceived || inputEvents.size() != 1) {
            throw new IllegalStateException("MRInput expects only a single input. Received: current eventListSize: " + inputEvents.size() + "Received previous input: " + this.eventReceived);
        }
        Event event = inputEvents.iterator().next();
        Preconditions.checkArgument((boolean)(event instanceof InputDataInformationEvent), (Object)(((Object)((Object)this)).getClass().getSimpleName() + " can only handle a single event of type: " + InputDataInformationEvent.class.getSimpleName()));
        this.processSplitEvent((InputDataInformationEvent)event);
    }

    public List<Event> close() throws IOException {
        this.mrReader.close();
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return null;
    }

    public Configuration getConfigUpdates() {
        if (!this.useNewApi) {
            return ((MRReaderMapred)this.mrReader).getConfigUpdates();
        }
        return null;
    }

    public float getProgress() throws ProgressFailedException, InterruptedException {
        try {
            return this.mrReader != null ? this.mrReader.getProgress() : 0.0f;
        }
        catch (IOException e) {
            throw new ProgressFailedException("getProgress encountered IOException ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSplitEvent(InputDataInformationEvent event) throws IOException {
        this.rrLock.lock();
        try {
            this.initFromEventInternal(event);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " notifying on RecordReader initialized");
            }
            this.rrInited.signal();
        }
        finally {
            this.rrLock.unlock();
        }
    }

    void checkAndAwaitRecordReaderInitialization() throws IOException {
        assert (this.rrLock.getHoldCount() == 1);
        this.rrLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " awaiting RecordReader initialization");
            }
            this.rrInited.await();
        }
        catch (Exception e) {
            throw new IOException("Interrupted waiting for RecordReader initiailization");
        }
        finally {
            this.rrLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void initFromEvent(InputDataInformationEvent initEvent) throws IOException {
        this.rrLock.lock();
        try {
            this.initFromEventInternal(initEvent);
        }
        finally {
            this.rrLock.unlock();
        }
    }

    private void initFromEventInternal(InputDataInformationEvent initEvent) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getContext().getSourceVertexName() + " initializing RecordReader from event");
        }
        Preconditions.checkState((initEvent != null ? 1 : 0) != 0, (Object)"InitEvent must be specified");
        MRRuntimeProtos.MRSplitProto splitProto = MRRuntimeProtos.MRSplitProto.parseFrom(ByteString.copyFrom((ByteBuffer)initEvent.getUserPayload()));
        org.apache.hadoop.mapreduce.InputSplit splitObj = null;
        long splitLength = -1L;
        if (this.useNewApi) {
            org.apache.hadoop.mapreduce.InputSplit split;
            splitObj = split = MRInputUtils.getNewSplitDetailsFromEvent(splitProto, (Configuration)this.jobConf);
            try {
                splitLength = split.getLength();
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupted while getting split length: ", (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " split Details -> SplitClass: " + split.getClass().getName() + ", NewSplit: " + split + ", length: " + splitLength);
            }
        } else {
            InputSplit split = MRInputUtils.getOldSplitDetailsFromEvent(splitProto, (Configuration)this.jobConf);
            splitObj = split;
            splitLength = split.getLength();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " split Details -> SplitClass: " + split.getClass().getName() + ", OldSplit: " + split + ", length: " + splitLength);
            }
        }
        if (splitLength != -1L) {
            this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_SPLIT_LENGTH_BYTES).increment(splitLength);
        }
        this.mrReader.setSplit(splitObj);
        LOG.info(this.getContext().getSourceVertexName() + " initialized RecordReader from event");
    }

    private static class MRInputHelpersInternal
    extends MRInputHelpers {
        private MRInputHelpersInternal() {
        }

        protected static UserPayload createMRInputPayloadWithGrouping(Configuration conf) throws IOException {
            return MRInputHelpers.createMRInputPayloadWithGrouping(conf);
        }

        protected static UserPayload createMRInputPayload(Configuration conf, MRRuntimeProtos.MRSplitsProto mrSplitsProto) throws IOException {
            return MRInputHelpers.createMRInputPayload(conf, mrSplitsProto);
        }
    }

    public static class MRInputConfigBuilder {
        final Configuration conf;
        final Class<?> inputFormat;
        final boolean inputFormatProvided;
        boolean useNewApi;
        boolean groupSplitsInAM = true;
        boolean generateSplitsInAM = true;
        String inputClassName = MRInput.class.getName();
        boolean getCredentialsForSourceFilesystem = true;
        String inputPaths = null;
        InputInitializerDescriptor customInitializerDescriptor = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        MRInputConfigBuilder(Configuration conf, Class<?> inputFormatParam) {
            this.conf = conf;
            if (inputFormatParam != null) {
                this.inputFormatProvided = true;
                this.inputFormat = inputFormatParam;
                if (org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(inputFormatParam)) {
                    this.useNewApi = false;
                    return;
                } else {
                    if (!InputFormat.class.isAssignableFrom(inputFormatParam)) throw new TezUncheckedException("inputFormat must be assignable from either org.apache.hadoop.mapred.InputFormat or org.apache.hadoop.mapreduce.InputFormat Given: " + inputFormatParam.getName());
                    this.useNewApi = true;
                }
                return;
            }
            this.inputFormatProvided = false;
            this.useNewApi = conf.getBoolean("mapred.mapper.new-api", true);
            try {
                if (this.useNewApi) {
                    this.inputFormat = conf.getClassByName(conf.get("mapreduce.job.inputformat.class"));
                    Preconditions.checkState((boolean)InputFormat.class.isAssignableFrom(this.inputFormat));
                } else {
                    this.inputFormat = conf.getClassByName(conf.get("mapred.input.format.class"));
                    Preconditions.checkState((boolean)org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(this.inputFormat));
                }
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            this.initializeInputPath();
        }

        MRInputConfigBuilder setInputClassName(String className) {
            this.inputClassName = className;
            return this;
        }

        private MRInputConfigBuilder setInputPaths(String inputPaths) {
            if (!org.apache.hadoop.mapred.FileInputFormat.class.isAssignableFrom(this.inputFormat) && !FileInputFormat.class.isAssignableFrom(this.inputFormat)) {
                throw new TezUncheckedException("When setting inputPaths the inputFormat must be assignable from either org.apache.hadoop.mapred.FileInputFormat or org.apache.hadoop.mapreduce.lib.input.FileInputFormat. Otherwise use the non-path configBuilder. Given: " + this.inputFormat.getName());
            }
            this.conf.set("mapreduce.input.fileinputformat.inputdir", inputPaths);
            this.inputPaths = inputPaths;
            return this;
        }

        private void initializeInputPath() {
            Preconditions.checkState((!this.inputFormatProvided ? 1 : 0) != 0, (Object)"Should only be invoked when no inputFormat is provided");
            if (org.apache.hadoop.mapred.FileInputFormat.class.isAssignableFrom(this.inputFormat) || FileInputFormat.class.isAssignableFrom(this.inputFormat)) {
                this.inputPaths = this.conf.get("mapreduce.input.fileinputformat.inputdir");
            }
        }

        public MRInputConfigBuilder groupSplits(boolean value) {
            this.groupSplitsInAM = value;
            return this;
        }

        public MRInputConfigBuilder generateSplitsInAM(boolean value) {
            this.generateSplitsInAM = value;
            return this;
        }

        public MRInputConfigBuilder getCredentialsForSourceFileSystem(boolean value) {
            this.getCredentialsForSourceFilesystem = value;
            return this;
        }

        public MRInputConfigBuilder setCustomInitializerDescriptor(InputInitializerDescriptor customInitializerDescriptor) {
            this.customInitializerDescriptor = customInitializerDescriptor;
            return this;
        }

        public DataSourceDescriptor build() {
            if ((org.apache.hadoop.mapred.FileInputFormat.class.isAssignableFrom(this.inputFormat) || FileInputFormat.class.isAssignableFrom(this.inputFormat)) && this.inputPaths == null) {
                throw new TezUncheckedException("InputPaths must be specified for InputFormats based on " + FileInputFormat.class.getName() + " or " + org.apache.hadoop.mapred.FileInputFormat.class.getName());
            }
            try {
                if (this.customInitializerDescriptor != null) {
                    return this.createCustomDataSource();
                }
                if (this.generateSplitsInAM) {
                    return this.createGeneratorDataSource();
                }
                return this.createDistributorDataSource();
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }

        private DataSourceDescriptor createDistributorDataSource() throws IOException {
            InputSplitInfoMem inputSplitInfo;
            this.setupBasicConf(this.conf);
            try {
                inputSplitInfo = MRInputHelpers.generateInputSplitsToMem(this.conf, false, 0);
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
            MRHelpers.translateMRConfToTez(this.conf);
            UserPayload payload = MRInputHelpersInternal.createMRInputPayload(this.conf, inputSplitInfo.getSplitsProto());
            Credentials credentials = null;
            if (this.getCredentialsForSourceFilesystem && inputSplitInfo.getCredentials() != null) {
                credentials = inputSplitInfo.getCredentials();
            }
            DataSourceDescriptor ds = DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.inputClassName).setUserPayload(payload)), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MRInputSplitDistributor.class.getName()), (int)inputSplitInfo.getNumTasks(), (Credentials)credentials, (VertexLocationHint)VertexLocationHint.create(inputSplitInfo.getTaskLocationHints()), null);
            if (this.conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
                ds.getInputDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)this.conf));
            }
            return ds;
        }

        private DataSourceDescriptor createCustomDataSource() throws IOException {
            this.setupBasicConf(this.conf);
            MRHelpers.translateMRConfToTez(this.conf);
            Collection<URI> uris = this.maybeGetURIsForCredentials();
            UserPayload payload = null;
            payload = this.groupSplitsInAM ? MRInputHelpersInternal.createMRInputPayloadWithGrouping(this.conf) : MRInputHelpersInternal.createMRInputPayload(this.conf, null);
            DataSourceDescriptor ds = DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.inputClassName).setUserPayload(payload)), (InputInitializerDescriptor)this.customInitializerDescriptor, null);
            if (this.conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
                ds.getInputDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)this.conf));
            }
            if (uris != null) {
                ds.addURIsForCredentials(uris);
            }
            return ds;
        }

        private DataSourceDescriptor createGeneratorDataSource() throws IOException {
            this.setupBasicConf(this.conf);
            MRHelpers.translateMRConfToTez(this.conf);
            Collection<URI> uris = this.maybeGetURIsForCredentials();
            UserPayload payload = null;
            payload = this.groupSplitsInAM ? MRInputHelpersInternal.createMRInputPayloadWithGrouping(this.conf) : MRInputHelpersInternal.createMRInputPayload(this.conf, null);
            DataSourceDescriptor ds = DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.inputClassName).setUserPayload(payload)), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MRInputAMSplitGenerator.class.getName()), null);
            if (this.conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
                ds.getInputDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)this.conf));
            }
            if (uris != null) {
                ds.addURIsForCredentials(uris);
            }
            return ds;
        }

        private void setupBasicConf(Configuration inputConf) {
            if (this.inputFormatProvided) {
                inputConf.setBoolean("mapred.mapper.new-api", this.useNewApi);
                if (this.useNewApi) {
                    inputConf.set("mapreduce.job.inputformat.class", this.inputFormat.getName());
                } else {
                    inputConf.set("mapred.input.format.class", this.inputFormat.getName());
                }
            }
        }

        private Collection<URI> maybeGetURIsForCredentials() {
            if (this.getCredentialsForSourceFilesystem && this.inputPaths != null) {
                try {
                    LinkedList uris = Lists.newLinkedList();
                    for (String inputPath : this.inputPaths.split(",")) {
                        Path path = new Path(inputPath);
                        FileSystem fs = path.getFileSystem(this.conf);
                        Path qPath = fs.makeQualified(path);
                        uris.add(qPath.toUri());
                    }
                    return uris;
                }
                catch (IOException e) {
                    throw new TezUncheckedException((Throwable)e);
                }
            }
            return null;
        }
    }
}

