/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitSizeEstimator;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezMapredSplitsGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(TezMapredSplitsGrouper.class);
    private static final SplitSizeEstimator DEFAULT_SPLIT_ESTIMATOR = new DefaultSplitSizeEstimator();

    Map<String, LocationHolder> createLocationsMap(Configuration conf) {
        if (conf.getBoolean("tez.grouping.repeatable", true)) {
            return new TreeMap<String, LocationHolder>();
        }
        return new HashMap<String, LocationHolder>();
    }

    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName) throws IOException {
        return this.getGroupedSplits(conf, originalSplits, desiredNumSplits, wrappedInputFormatName, null);
    }

    /*
     * WARNING - void declaration
     */
    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimator estimator) throws IOException {
        void var21_46;
        void var21_44;
        LOG.info("Grouping splits in Tez");
        Preconditions.checkArgument((originalSplits != null ? 1 : 0) != 0, (Object)"Splits must be specified");
        int configNumSplits = conf.getInt("tez.grouping.split-count", 0);
        if (configNumSplits > 0) {
            desiredNumSplits = configNumSplits;
            LOG.info("Desired numSplits overridden by config to: " + desiredNumSplits);
        }
        if (estimator == null) {
            estimator = DEFAULT_SPLIT_ESTIMATOR;
        }
        if (configNumSplits <= 0 && originalSplits.length != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            long totalLength = 0L;
            InputSplit[] inputSplitArray = originalSplits;
            int n = inputSplitArray.length;
            for (int i = 0; i < n; ++i) {
                InputSplit split = inputSplitArray[i];
                totalLength += estimator.getEstimatedSize(split);
            }
            int splitCount = desiredNumSplits > 0 ? desiredNumSplits : originalSplits.length;
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = conf.getLong("tez.grouping.max-size", 0x40000000L);
            if (maxLengthPerGroup < (minLengthPerGroup = conf.getLong("tez.grouping.min-size", 0x3200000L)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info("Desired splits: " + desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length);
                desiredNumSplits = newDesiredNumSplits;
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                LOG.info("Desired splits: " + desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length);
                desiredNumSplits = newDesiredNumSplits;
            }
        }
        if (originalSplits == null) {
            LOG.info("Null original splits");
            return null;
        }
        if (desiredNumSplits == 0 || originalSplits.length == 0 || desiredNumSplits >= originalSplits.length) {
            LOG.info("Using original number of splits: " + originalSplits.length + " desired splits: " + desiredNumSplits);
            InputSplit[] groupedSplits = new TezGroupedSplit[originalSplits.length];
            int i = 0;
            for (InputSplit split : originalSplits) {
                TezGroupedSplit newSplit = new TezGroupedSplit(1, wrappedInputFormatName, split.getLocations());
                newSplit.addSplit(split);
                groupedSplits[i++] = newSplit;
            }
            return groupedSplits;
        }
        String emptyLocation = "EmptyLocation";
        String[] emptyLocations = new String[]{emptyLocation};
        ArrayList<TezGroupedSplit> groupedSplitsList = new ArrayList<TezGroupedSplit>(desiredNumSplits);
        long totalLength = 0L;
        Map<String, LocationHolder> distinctLocations = this.createLocationsMap(conf);
        for (InputSplit split : originalSplits) {
            totalLength += estimator.getEstimatedSize(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String string : locations) {
                void var21_40;
                if (string == null) {
                    String string2 = emptyLocation;
                }
                distinctLocations.put((String)var21_40, null);
            }
        }
        long lengthPerGroup = totalLength / (long)desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.length / numNodeLocations;
        int numSplitsInGroup = originalSplits.length / desiredNumSplits;
        for (String location : distinctLocations.keySet()) {
            distinctLocations.put(location, new LocationHolder(numSplitsPerLocation + 1));
        }
        HashSet<String> locSet = new HashSet<String>();
        InputSplit[] location = originalSplits;
        int n = location.length;
        boolean bl = false;
        while (var21_44 < n) {
            InputSplit split = location[var21_44];
            locSet.clear();
            SplitHolder splitHolder = new SplitHolder(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location2 : locations) {
                if (location2 == null) {
                    location2 = emptyLocation;
                }
                locSet.add(location2);
            }
            for (String location3 : locSet) {
                LocationHolder holder = distinctLocations.get(location3);
                holder.splits.add(splitHolder);
            }
            ++var21_44;
        }
        boolean groupByLength = conf.getBoolean("tez.grouping.by-length", true);
        boolean groupByCount = conf.getBoolean("tez.grouping.by-count", false);
        if (!groupByLength && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.grouping.by-length, tez.grouping.by-count");
        }
        LOG.info("Desired numSplits: " + desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.length + " . Grouping by length: " + groupByLength + " count: " + groupByCount);
        boolean bl2 = false;
        ArrayList<SplitHolder> group = new ArrayList<SplitHolder>(numSplitsInGroup + 1);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (var21_46 < originalSplits.length) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry<String, LocationHolder> entry : distinctLocations.entrySet()) {
                group.clear();
                groupLocationSet.clear();
                String location4 = entry.getKey();
                LocationHolder locationHolder = entry.getValue();
                SplitHolder splitHolder = locationHolder.getUnprocessedHeadSplit();
                if (splitHolder == null) continue;
                int oldHeadIndex = locationHolder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    group.add(splitHolder);
                    locationHolder.incrementHeadIndex();
                } while ((splitHolder = locationHolder.getUnprocessedHeadSplit()) != null && (!groupByLength || (groupLength += estimator.getEstimatedSize(splitHolder.split)) + estimator.getEstimatedSize(splitHolder.split) <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!locationHolder.isEmpty() || allowSmallGroups || groupByLength && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    locationHolder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                String[] groupLocation = new String[]{location4};
                if (location4 == emptyLocation) {
                    groupLocation = null;
                } else if (doingRackLocal) {
                    for (SplitHolder splitHolder2 : group) {
                        String[] locations = splitHolder2.split.getLocations();
                        if (locations == null) continue;
                        String[] stringArray = locations;
                        int n2 = stringArray.length;
                        for (int i = 0; i < n2; ++i) {
                            String loc = stringArray[i];
                            if (loc == null) continue;
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray(groupLocation);
                }
                TezGroupedSplit groupedSplit = new TezGroupedSplit(group.size(), wrappedInputFormatName, groupLocation, doingRackLocal && location4 != emptyLocation ? location4 : null);
                for (SplitHolder groupedSplitHolder : group) {
                    groupedSplit.addSplit(groupedSplitHolder.split);
                    Preconditions.checkState((!groupedSplitHolder.isProcessed ? 1 : 0) != 0, (Object)("Duplicates in grouping at location: " + (String)location4));
                    groupedSplitHolder.isProcessed = true;
                    ++var21_46;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Grouped " + group.size() + " length: " + groupedSplit.getLength() + " split at: " + (String)location4);
                }
                groupedSplitsList.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.length - var21_46;
                HashSet<InputSplit> remainingSplits = new HashSet<InputSplit>(numRemainingSplits);
                for (Map.Entry entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = (LocationHolder)entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitHolder splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder.split);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                Map<String, LocationHolder> map = this.createLocationsMap(conf);
                for (String location5 : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location5 != emptyLocation) {
                        rack = RackResolver.resolve((String)location5).getNetworkLocation();
                    }
                    locToRackMap.put(location5, rack);
                    if (map.get(rack) != null) continue;
                    map.put(rack, new LocationHolder(numRemainingSplits));
                }
                distinctLocations.clear();
                HashSet rackSet = new HashSet(map.size());
                int numRackSplitsToGroup = remainingSplits.size();
                for (InputSplit split : originalSplits) {
                    void var39_90;
                    if (numRackSplitsToGroup == 0) break;
                    if (!remainingSplits.contains(split)) continue;
                    --numRackSplitsToGroup;
                    rackSet.clear();
                    SplitHolder splitHolder = new SplitHolder(split);
                    String[] stringArray = split.getLocations();
                    if (stringArray == null || stringArray.length == 0) {
                        String[] stringArray2 = emptyLocations;
                    }
                    for (String location6 : var39_90) {
                        if (location6 == null) {
                            location6 = emptyLocation;
                        }
                        rackSet.add(locToRackMap.get(location6));
                    }
                    for (String rack : rackSet) {
                        map.get((Object)rack).splits.add(splitHolder);
                    }
                }
                remainingSplits.clear();
                distinctLocations = map;
                float rackSplitReduction = conf.getFloat("tez.grouping.rack-split-reduction", 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info("Doing rack local after iteration: " + iterations + " splitsProcessed: " + (int)var21_46 + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup);
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + (int)var21_46 + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Iteration: " + iterations + " splitsProcessed: " + (int)var21_46 + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size());
        }
        InputSplit[] groupedSplits = new InputSplit[groupedSplitsList.size()];
        groupedSplitsList.toArray(groupedSplits);
        LOG.info("Number of splits desired: " + desiredNumSplits + " created: " + groupedSplitsList.size() + " splitsProcessed: " + (int)var21_46);
        return groupedSplits;
    }

    static final class DefaultSplitSizeEstimator
    implements SplitSizeEstimator {
        DefaultSplitSizeEstimator() {
        }

        @Override
        public long getEstimatedSize(InputSplit split) throws IOException {
            return split.getLength();
        }
    }

    static class LocationHolder {
        List<SplitHolder> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitHolder>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitHolder getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitHolder holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }

    static class SplitHolder {
        InputSplit split;
        boolean isProcessed = false;

        SplitHolder(InputSplit split) {
            this.split = split;
        }
    }
}

