/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.lib;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRReaderMapReduce
extends MRReader {
    private static final Logger LOG = LoggerFactory.getLogger(MRReader.class);
    private final TezCounter inputRecordCounter;
    private final TaskAttemptContext taskAttemptContext;
    private final InputFormat inputFormat;
    protected RecordReader recordReader;
    private InputSplit inputSplit;
    private boolean setupComplete = false;

    public MRReaderMapReduce(JobConf jobConf, TezCounters tezCounters, TezCounter inputRecordCounter, long clusterId, int vertexIndex, int appId, int taskIndex, int taskAttemptNumber) throws IOException {
        this(jobConf, null, tezCounters, inputRecordCounter, clusterId, vertexIndex, appId, taskIndex, taskAttemptNumber);
    }

    public MRReaderMapReduce(JobConf jobConf, InputSplit inputSplit, TezCounters tezCounters, TezCounter inputRecordCounter, long clusterId, int vertexIndex, int appId, int taskIndex, int taskAttemptNumber) throws IOException {
        Class inputFormatClazz;
        this.inputRecordCounter = inputRecordCounter;
        this.taskAttemptContext = new TaskAttemptContextImpl((Configuration)jobConf, tezCounters, clusterId, vertexIndex, appId, taskIndex, taskAttemptNumber, true, null);
        try {
            inputFormatClazz = this.taskAttemptContext.getInputFormatClass();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to instantiate InputFormat class", e);
        }
        this.inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClazz, (Configuration)jobConf);
        if (inputSplit != null) {
            this.inputSplit = inputSplit;
            this.setupNewRecordReader();
        }
    }

    @Override
    public void setSplit(Object inputSplit) throws IOException {
        this.inputSplit = (InputSplit)inputSplit;
        this.setupNewRecordReader();
    }

    @Override
    public boolean isSetup() {
        return this.setupComplete;
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.setupComplete ? this.recordReader.getProgress() : 0.0f;
    }

    @Override
    public void close() throws IOException {
        if (this.setupComplete) {
            this.recordReader.close();
        }
    }

    @Override
    public Object getSplit() {
        return this.inputSplit;
    }

    @Override
    public Object getRecordReader() {
        return this.recordReader;
    }

    public boolean next() throws IOException {
        boolean hasNext;
        try {
            hasNext = this.recordReader.nextKeyValue();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOInterruptedException("Interrupted while checking for next key-value", (Throwable)e);
        }
        if (hasNext) {
            this.inputRecordCounter.increment(1L);
        } else {
            this.hasCompletedProcessing();
            this.completedProcessing = true;
        }
        return hasNext;
    }

    public Object getCurrentKey() throws IOException {
        try {
            return this.recordReader.getCurrentKey();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while fetching next key", e);
        }
    }

    public Object getCurrentValue() throws IOException {
        try {
            return this.recordReader.getCurrentValue();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while fetching next value", e);
        }
    }

    private void setupNewRecordReader() throws IOException {
        Preconditions.checkNotNull((Object)this.inputSplit, (Object)"Input split hasn't yet been setup");
        try {
            this.recordReader = this.inputFormat.createRecordReader(this.inputSplit, this.taskAttemptContext);
            this.recordReader.initialize(this.inputSplit, this.taskAttemptContext);
            this.setupComplete = true;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while creating record reader", e);
        }
    }
}

