/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MRInputHelpers {
    private static final Log LOG = LogFactory.getLog(MRInputHelpers.class);
    private static final int SPLIT_SERIALIZED_LENGTH_ESTIMATE = 40;
    static final String JOB_SPLIT_RESOURCE_NAME = "job.split";
    static final String JOB_SPLIT_METAINFO_RESOURCE_NAME = "job.splitmetainfo";

    @InterfaceStability.Unstable
    public static DataSourceDescriptor configureMRInputWithLegacySplitGeneration(Configuration conf, Path splitsDir, boolean useLegacyInput) {
        InputSplitInfoDisk inputSplitInfo = null;
        try {
            inputSplitInfo = MRInputHelpers.generateInputSplits(conf, splitsDir);
            InputDescriptor inputDescriptor = (InputDescriptor)InputDescriptor.create((String)(useLegacyInput ? MRInputLegacy.class.getName() : MRInput.class.getName())).setUserPayload(MRInputHelpers.createMRInputPayload(conf, null));
            HashMap<String, LocalResource> additionalLocalResources = new HashMap<String, LocalResource>();
            MRInputHelpers.updateLocalResourcesForInputSplits(conf, inputSplitInfo, additionalLocalResources);
            DataSourceDescriptor dsd = DataSourceDescriptor.create((InputDescriptor)inputDescriptor, null, (int)inputSplitInfo.getNumTasks(), (Credentials)inputSplitInfo.getCredentials(), (VertexLocationHint)VertexLocationHint.create(inputSplitInfo.getTaskLocationHints()), additionalLocalResources);
            return dsd;
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to generate InputSplits", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException("Failed to generate InputSplits", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TezUncheckedException("Failed to generate InputSplits", (Throwable)e);
        }
    }

    @InterfaceStability.Evolving
    public static MRRuntimeProtos.MRInputUserPayloadProto parseMRInputPayload(UserPayload payload) throws IOException {
        return MRRuntimeProtos.MRInputUserPayloadProto.parseFrom(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
    }

    @InterfaceStability.Evolving
    public static InputSplit createOldFormatSplitFromUserPayload(MRRuntimeProtos.MRSplitProto splitProto, SerializationFactory serializationFactory) throws IOException {
        Class<?> clazz;
        Preconditions.checkNotNull((Object)splitProto, (Object)"splitProto cannot be null");
        String className = splitProto.getSplitClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to load InputSplit class: [" + className + "]", e);
        }
        Deserializer deserializer = serializationFactory.getDeserializer(clazz);
        deserializer.open(splitProto.getSplitBytes().newInput());
        InputSplit inputSplit = (InputSplit)deserializer.deserialize(null);
        deserializer.close();
        return inputSplit;
    }

    @InterfaceStability.Evolving
    public static org.apache.hadoop.mapreduce.InputSplit createNewFormatSplitFromUserPayload(MRRuntimeProtos.MRSplitProto splitProto, SerializationFactory serializationFactory) throws IOException {
        Class<?> clazz;
        Preconditions.checkNotNull((Object)splitProto, (Object)"splitProto must be specified");
        String className = splitProto.getSplitClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to load InputSplit class: [" + className + "]", e);
        }
        Deserializer deserializer = serializationFactory.getDeserializer(clazz);
        deserializer.open(splitProto.getSplitBytes().newInput());
        org.apache.hadoop.mapreduce.InputSplit inputSplit = (org.apache.hadoop.mapreduce.InputSplit)deserializer.deserialize(null);
        deserializer.close();
        return inputSplit;
    }

    @InterfaceStability.Evolving
    public static <T extends org.apache.hadoop.mapreduce.InputSplit> MRRuntimeProtos.MRSplitProto createSplitProto(T newSplit, SerializationFactory serializationFactory) throws IOException, InterruptedException {
        MRRuntimeProtos.MRSplitProto.Builder builder = MRRuntimeProtos.MRSplitProto.newBuilder();
        builder.setSplitClassName(newSplit.getClass().getName());
        Serializer serializer = serializationFactory.getSerializer(newSplit.getClass());
        ByteString.Output out = ByteString.newOutput((int)40);
        serializer.open((OutputStream)out);
        serializer.serialize(newSplit);
        ByteString splitBs = out.toByteString();
        builder.setSplitBytes(splitBs);
        return builder.build();
    }

    @InterfaceStability.Evolving
    public static MRRuntimeProtos.MRSplitProto createSplitProto(InputSplit oldSplit) throws IOException {
        MRRuntimeProtos.MRSplitProto.Builder builder = MRRuntimeProtos.MRSplitProto.newBuilder();
        builder.setSplitClassName(oldSplit.getClass().getName());
        ByteString.Output os = ByteString.newOutput((int)40);
        oldSplit.write((DataOutput)new DataOutputStream((OutputStream)os));
        ByteString splitBs = os.toByteString();
        builder.setSplitBytes(splitBs);
        return builder.build();
    }

    @InterfaceStability.Unstable
    public static InputSplitInfoMem generateInputSplitsToMem(Configuration conf, boolean groupSplits, int targetTasks) throws IOException, ClassNotFoundException, InterruptedException {
        InputSplitInfoMem splitInfoMem = null;
        JobConf jobConf = new JobConf(conf);
        if (jobConf.getUseNewMapper()) {
            LOG.info((Object)"Generating mapreduce api input splits");
            Job job = Job.getInstance((Configuration)conf);
            org.apache.hadoop.mapreduce.InputSplit[] splits = MRInputHelpers.generateNewSplits((JobContext)job, groupSplits, targetTasks);
            splitInfoMem = new InputSplitInfoMem(splits, MRInputHelpers.createTaskLocationHintsFromSplits(splits), splits.length, job.getCredentials(), job.getConfiguration());
        } else {
            LOG.info((Object)"Generating mapred api input splits");
            InputSplit[] splits = MRInputHelpers.generateOldSplits(jobConf, groupSplits, targetTasks);
            splitInfoMem = new InputSplitInfoMem(splits, MRInputHelpers.createTaskLocationHintsFromSplits(splits), splits.length, jobConf.getCredentials(), (Configuration)jobConf);
        }
        LOG.info((Object)("NumSplits: " + splitInfoMem.getNumTasks() + ", SerializedSize: " + splitInfoMem.getSplitsProto().getSerializedSize()));
        return splitInfoMem;
    }

    private static List<TaskLocationHint> createTaskLocationHintsFromSplits(org.apache.hadoop.mapreduce.InputSplit[] newFormatSplits) {
        Iterable iterable = Iterables.transform(Arrays.asList(newFormatSplits), (Function)new Function<org.apache.hadoop.mapreduce.InputSplit, TaskLocationHint>(){

            public TaskLocationHint apply(org.apache.hadoop.mapreduce.InputSplit input) {
                try {
                    if (input instanceof TezGroupedSplit) {
                        String rack = ((TezGroupedSplit)input).getRack();
                        if (rack == null) {
                            if (input.getLocations() != null) {
                                return TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                            }
                            return TaskLocationHint.createTaskLocationHint(null, null);
                        }
                        return TaskLocationHint.createTaskLocationHint(null, Collections.singleton(rack));
                    }
                    return TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    private static List<TaskLocationHint> createTaskLocationHintsFromSplits(InputSplit[] oldFormatSplits) {
        Iterable iterable = Iterables.transform(Arrays.asList(oldFormatSplits), (Function)new Function<InputSplit, TaskLocationHint>(){

            public TaskLocationHint apply(InputSplit input) {
                try {
                    if (input instanceof org.apache.hadoop.mapred.split.TezGroupedSplit) {
                        String rack = ((org.apache.hadoop.mapred.split.TezGroupedSplit)input).getRack();
                        if (rack == null) {
                            if (input.getLocations() != null) {
                                return TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                            }
                            return TaskLocationHint.createTaskLocationHint(null, null);
                        }
                        return TaskLocationHint.createTaskLocationHint(null, Collections.singleton(rack));
                    }
                    return TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    private static org.apache.hadoop.mapreduce.InputSplit[] generateNewSplits(JobContext jobContext, boolean groupSplits, int numTasks) throws ClassNotFoundException, IOException, InterruptedException {
        Configuration conf = jobContext.getConfiguration();
        org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat inputFormat = null;
        try {
            inputFormat = (org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat)((Object)ReflectionUtils.newInstance((Class)jobContext.getInputFormatClass(), (Configuration)conf));
        }
        catch (ClassNotFoundException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat finalInputFormat = inputFormat;
        if (groupSplits) {
            org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat groupedFormat = new org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat();
            groupedFormat.setConf(conf);
            groupedFormat.setInputFormat(inputFormat);
            groupedFormat.setDesiredNumberOfSplits(numTasks);
            finalInputFormat = groupedFormat;
        } else {
            finalInputFormat = inputFormat;
        }
        List array = finalInputFormat.getSplits(jobContext);
        org.apache.hadoop.mapreduce.InputSplit[] splits = array.toArray(new org.apache.hadoop.mapreduce.InputSplit[array.size()]);
        Arrays.sort(splits, new InputSplitComparator());
        return splits;
    }

    private static InputSplit[] generateOldSplits(JobConf jobConf, boolean groupSplits, int numTasks) throws IOException {
        TezGroupedSplitsInputFormat inputFormat;
        try {
            inputFormat = jobConf.getInputFormat();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
        TezGroupedSplitsInputFormat finalInputFormat = inputFormat;
        if (groupSplits) {
            TezGroupedSplitsInputFormat groupedFormat = new TezGroupedSplitsInputFormat();
            groupedFormat.setConf((Configuration)jobConf);
            groupedFormat.setInputFormat(inputFormat);
            groupedFormat.setDesiredNumberOfSplits(numTasks);
            finalInputFormat = groupedFormat;
        } else {
            finalInputFormat = inputFormat;
        }
        InputSplit[] splits = finalInputFormat.getSplits(jobConf, jobConf.getNumMapTasks());
        Arrays.sort(splits, new OldInputSplitComparator());
        return splits;
    }

    private static InputSplitInfoDisk writeNewSplits(JobContext jobContext, Path inputSplitDir) throws IOException, InterruptedException, ClassNotFoundException {
        org.apache.hadoop.mapreduce.InputSplit[] splits = MRInputHelpers.generateNewSplits(jobContext, false, 0);
        Configuration conf = jobContext.getConfiguration();
        JobSplitWriter.createSplitFiles((Path)inputSplitDir, (Configuration)conf, (FileSystem)inputSplitDir.getFileSystem(conf), (org.apache.hadoop.mapreduce.InputSplit[])splits);
        ArrayList<TaskLocationHint> locationHints = new ArrayList<TaskLocationHint>(splits.length);
        for (int i = 0; i < splits.length; ++i) {
            locationHints.add(TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(splits[i].getLocations())), null));
        }
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitDir), splits.length, locationHints, jobContext.getCredentials());
    }

    private static InputSplitInfoDisk writeOldSplits(JobConf jobConf, Path inputSplitDir) throws IOException {
        InputSplit[] splits = MRInputHelpers.generateOldSplits(jobConf, false, 0);
        JobSplitWriter.createSplitFiles((Path)inputSplitDir, (Configuration)jobConf, (FileSystem)inputSplitDir.getFileSystem((Configuration)jobConf), (InputSplit[])splits);
        ArrayList<TaskLocationHint> locationHints = new ArrayList<TaskLocationHint>(splits.length);
        for (int i = 0; i < splits.length; ++i) {
            locationHints.add(TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(splits[i].getLocations())), null));
        }
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitDir), splits.length, locationHints, jobConf.getCredentials());
    }

    private static InputSplitInfoDisk generateInputSplits(Configuration conf, Path inputSplitsDir) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance((Configuration)conf);
        JobConf jobConf = new JobConf(conf);
        conf.setBoolean("mapreduce.tez.splits.via.events", false);
        if (jobConf.getUseNewMapper()) {
            LOG.info((Object)("Generating new input splits, splitsDir=" + inputSplitsDir.toString()));
            return MRInputHelpers.writeNewSplits((JobContext)job, inputSplitsDir);
        }
        LOG.info((Object)("Generating old input splits, splitsDir=" + inputSplitsDir.toString()));
        return MRInputHelpers.writeOldSplits(jobConf, inputSplitsDir);
    }

    private static void updateLocalResourcesForInputSplits(Configuration conf, InputSplitInfo inputSplitInfo, Map<String, LocalResource> localResources) throws IOException {
        if (localResources.containsKey(JOB_SPLIT_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.split");
        }
        if (localResources.containsKey(JOB_SPLIT_METAINFO_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.splitmetainfo");
        }
        FileSystem splitsFS = inputSplitInfo.getSplitsFile().getFileSystem(conf);
        FileStatus splitFileStatus = splitsFS.getFileStatus(inputSplitInfo.getSplitsFile());
        FileStatus metaInfoFileStatus = splitsFS.getFileStatus(inputSplitInfo.getSplitsMetaInfoFile());
        localResources.put(JOB_SPLIT_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)splitFileStatus.getLen(), (long)splitFileStatus.getModificationTime()));
        localResources.put(JOB_SPLIT_METAINFO_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsMetaInfoFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)metaInfoFileStatus.getLen(), (long)metaInfoFileStatus.getModificationTime()));
    }

    @InterfaceAudience.Private
    protected static UserPayload createMRInputPayloadWithGrouping(Configuration conf) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration must be specified");
        return MRInputHelpers.createMRInputPayload(TezUtils.createByteStringFromConf((Configuration)conf), null, true);
    }

    @InterfaceAudience.Private
    protected static UserPayload createMRInputPayload(Configuration conf, MRRuntimeProtos.MRSplitsProto mrSplitsProto) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration must be specified");
        return MRInputHelpers.createMRInputPayload(TezUtils.createByteStringFromConf((Configuration)conf), mrSplitsProto, false);
    }

    private static UserPayload createMRInputPayload(ByteString bytes, MRRuntimeProtos.MRSplitsProto mrSplitsProto, boolean isGrouped) throws IOException {
        MRRuntimeProtos.MRInputUserPayloadProto.Builder userPayloadBuilder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        userPayloadBuilder.setConfigurationBytes(bytes);
        if (mrSplitsProto != null) {
            userPayloadBuilder.setSplits(mrSplitsProto);
        }
        userPayloadBuilder.setGroupingEnabled(isGrouped);
        return UserPayload.create((ByteBuffer)userPayloadBuilder.build().toByteString().asReadOnlyByteBuffer());
    }

    private static class OldInputSplitComparator
    implements Comparator<InputSplit> {
        private OldInputSplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("Problem getting input split size", ie);
            }
        }
    }

    private static class InputSplitComparator
    implements Comparator<org.apache.hadoop.mapreduce.InputSplit> {
        private InputSplitComparator() {
        }

        @Override
        public int compare(org.apache.hadoop.mapreduce.InputSplit o1, org.apache.hadoop.mapreduce.InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
        }
    }
}

