/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.TezMapReduceSplitsGrouper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MRInputAMSplitGenerator
extends InputInitializer {
    private boolean sendSerializedEvents;
    private static final Log LOG = LogFactory.getLog(MRInputAMSplitGenerator.class);

    public MRInputAMSplitGenerator(InputInitializerContext initializerContext) {
        super(initializerContext);
    }

    public List<Event> initialize() throws Exception {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRInputHelpers.parseMRInputPayload(this.getContext().getInputUserPayload());
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to parse MRInput payload into prot: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        Configuration conf = TezUtils.createConfFromByteString((ByteString)userPayloadProto.getConfigurationBytes());
        this.sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        LOG.info((Object)("Emitting serialized splits: " + this.sendSerializedEvents));
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time converting ByteString to configuration: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        int totalResource = this.getContext().getTotalAvailableResource().getMemory();
        int taskResource = this.getContext().getVertexTaskResource().getMemory();
        float waves = conf.getFloat("tez.grouping.split-waves", TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_WAVES_DEFAULT);
        int numTasks = (int)((float)totalResource * waves / (float)taskResource);
        LOG.info((Object)("Input " + this.getContext().getInputName() + " asking for " + numTasks + " tasks. Headroom: " + totalResource + " Task Resource: " + taskResource + " waves: " + waves));
        JobConf jobConf = new JobConf(conf);
        jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        InputSplitInfoMem inputSplitInfo = null;
        boolean groupSplits = userPayloadProto.getGroupingEnabled();
        if (groupSplits) {
            LOG.info((Object)"Grouping input splits");
            inputSplitInfo = MRInputHelpers.generateInputSplitsToMem((Configuration)jobConf, true, numTasks);
        } else {
            inputSplitInfo = MRInputHelpers.generateInputSplitsToMem((Configuration)jobConf, false, 0);
        }
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to create splits to mem: " + sw.elapsedMillis()));
        }
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create(inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add(configureVertexEvent);
        if (this.sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
                events.add(diEvent);
            }
        } else {
            int count = 0;
            if (inputSplitInfo.holdsNewFormatSplits()) {
                for (InputSplit split : inputSplitInfo.getNewFormatSplits()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                    events.add(diEvent);
                }
            } else {
                for (org.apache.hadoop.mapred.InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                    InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                    events.add(diEvent);
                }
            }
        }
        return events;
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        throw new UnsupportedOperationException("Not expecting to handle any events");
    }
}

