/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.mapreduce.hadoop.mapreduce.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

@InterfaceAudience.Public
public class MROutput
extends AbstractLogicalOutput {
    private static final Log LOG = LogFactory.getLog(MROutput.class);
    private final NumberFormat taskNumberFormat = NumberFormat.getInstance();
    private final NumberFormat nonTaskNumberFormat = NumberFormat.getInstance();
    private JobConf jobConf;
    boolean useNewApi;
    private AtomicBoolean flushed = new AtomicBoolean(false);
    org.apache.hadoop.mapreduce.OutputFormat newOutputFormat;
    RecordWriter newRecordWriter;
    OutputFormat oldOutputFormat;
    org.apache.hadoop.mapred.RecordWriter oldRecordWriter;
    private TezCounter outputRecordCounter;
    @VisibleForTesting
    TaskAttemptContext newApiTaskAttemptContext;
    @VisibleForTesting
    org.apache.hadoop.mapred.TaskAttemptContext oldApiTaskAttemptContext;
    @VisibleForTesting
    boolean isMapperOutput;
    protected OutputCommitter committer;

    public static MROutputConfigBuilder createConfigBuilder(Configuration conf, @Nullable Class<?> outputFormat) {
        return new MROutputConfigBuilder(conf, outputFormat);
    }

    public static MROutputConfigBuilder createConfigBuilder(Configuration conf, @Nullable Class<?> outputFormat, @Nullable String outputPath) {
        MROutputConfigBuilder configurer = new MROutputConfigBuilder(conf, outputFormat);
        if (outputPath != null) {
            configurer.setOutputPath(outputPath);
        }
        return configurer;
    }

    public MROutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public List<Event> initialize() throws IOException, InterruptedException {
        LOG.info((Object)"Initializing Simple Output");
        this.getContext().requestInitialMemory(0L, null);
        this.taskNumberFormat.setMinimumIntegerDigits(5);
        this.taskNumberFormat.setGroupingUsed(false);
        this.nonTaskNumberFormat.setMinimumIntegerDigits(3);
        this.nonTaskNumberFormat.setGroupingUsed(false);
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.jobConf = new JobConf(conf);
        this.jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        this.isMapperOutput = this.jobConf.getBoolean("tez.mapreduce.is_map_processor", false);
        this.useNewApi = this.isMapperOutput ? this.jobConf.getUseNewMapper() : this.jobConf.getUseNewReducer();
        this.jobConf.setInt("mapreduce.job.application.attempt.id", this.getContext().getDAGAttemptNumber());
        TaskAttemptID taskAttemptId = TaskAttemptContextImpl.createMockTaskAttemptID(this.getContext().getApplicationId().getClusterTimestamp(), this.getContext().getTaskVertexIndex(), this.getContext().getApplicationId().getId(), this.getContext().getTaskIndex(), this.getContext().getTaskAttemptNumber(), this.isMapperOutput);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        this.jobConf.setBoolean("mapreduce.task.ismap", this.isMapperOutput);
        this.jobConf.setInt("mapreduce.task.partition", taskAttemptId.getTaskID().getId());
        this.jobConf.set("mapreduce.job.id", taskAttemptId.getJobID().toString());
        if (this.useNewApi && this.jobConf.get("mapreduce.output.basename") == null) {
            this.jobConf.set("mapreduce.output.basename", this.getOutputFileNamePrefix());
        }
        this.outputRecordCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS);
        if (this.useNewApi) {
            this.newApiTaskAttemptContext = this.createTaskAttemptContext(taskAttemptId);
            try {
                this.newOutputFormat = (org.apache.hadoop.mapreduce.OutputFormat)ReflectionUtils.newInstance((Class)this.newApiTaskAttemptContext.getOutputFormatClass(), (Configuration)this.jobConf);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                this.newRecordWriter = this.newOutputFormat.getRecordWriter(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while creating record writer", e);
            }
        }
        this.oldApiTaskAttemptContext = new org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl(this.jobConf, taskAttemptId, new MRTaskReporter(this.getContext()));
        this.oldOutputFormat = this.jobConf.getOutputFormat();
        FileSystem fs = FileSystem.get((Configuration)this.jobConf);
        String finalName = this.getOutputName();
        this.oldRecordWriter = this.oldOutputFormat.getRecordWriter(fs, this.jobConf, finalName, (Progressable)new MRReporter(this.getContext().getCounters()));
        this.initCommitter(this.jobConf, this.useNewApi);
        LOG.info((Object)("Initialized Simple Output, using_new_api: " + this.useNewApi));
        return null;
    }

    public void start() {
    }

    public void initCommitter(JobConf job, boolean useNewApi) throws IOException, InterruptedException {
        if (useNewApi) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"using new api for output committer");
            }
            this.committer = this.newOutputFormat.getOutputCommitter(this.newApiTaskAttemptContext);
        } else {
            this.committer = job.getOutputCommitter();
        }
        Path outputPath = org.apache.hadoop.mapred.FileOutputFormat.getOutputPath((JobConf)job);
        if (outputPath != null) {
            if (this.committer instanceof FileOutputCommitter) {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)((FileOutputCommitter)this.committer).getTaskAttemptPath(this.oldApiTaskAttemptContext));
            } else {
                org.apache.hadoop.mapred.FileOutputFormat.setWorkOutputPath((JobConf)job, (Path)outputPath);
            }
        }
        if (useNewApi) {
            this.committer.setupTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.setupTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public boolean isCommitRequired() throws IOException {
        if (this.useNewApi) {
            return this.committer.needsTaskCommit(this.newApiTaskAttemptContext);
        }
        return this.committer.needsTaskCommit((TaskAttemptContext)this.oldApiTaskAttemptContext);
    }

    private TaskAttemptContext createTaskAttemptContext(TaskAttemptID attemptId) {
        return new TaskAttemptContextImpl((Configuration)this.jobConf, (org.apache.hadoop.mapreduce.TaskAttemptID)attemptId, this.getContext().getCounters(), this.isMapperOutput, null);
    }

    private String getOutputFileNamePrefix() {
        String prefix = this.jobConf.get("mapreduce.tez.mroutput.file-name.prefix");
        if (prefix == null) {
            prefix = "part-v" + this.nonTaskNumberFormat.format(this.getContext().getTaskVertexIndex()) + "-o" + this.nonTaskNumberFormat.format(this.getContext().getOutputIndex());
        }
        return prefix;
    }

    private String getOutputName() {
        return this.getOutputFileNamePrefix() + "-" + this.taskNumberFormat.format(this.getContext().getTaskIndex());
    }

    public KeyValueWriter getWriter() throws IOException {
        return new KeyValueWriter(){
            private final boolean useNewWriter;
            {
                this.useNewWriter = MROutput.this.useNewApi;
            }

            public void write(Object key, Object value) throws IOException {
                if (this.useNewWriter) {
                    try {
                        MROutput.this.newRecordWriter.write(key, value);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Interrupted while writing next key-value", e);
                    }
                } else {
                    MROutput.this.oldRecordWriter.write(key, value);
                }
                MROutput.this.outputRecordCounter.increment(1L);
            }
        };
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws IOException {
        this.flush();
        return null;
    }

    public void flush() throws IOException {
        if (this.flushed.getAndSet(true)) {
            return;
        }
        LOG.info((Object)"Flushing Simple Output");
        if (this.useNewApi) {
            try {
                this.newRecordWriter.close(this.newApiTaskAttemptContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing record writer", e);
            }
        } else {
            this.oldRecordWriter.close(null);
        }
        LOG.info((Object)"Flushed Simple Output");
    }

    public void commit() throws IOException {
        this.flush();
        if (this.useNewApi) {
            this.committer.commitTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.commitTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public void abort() throws IOException {
        this.flush();
        if (this.useNewApi) {
            this.committer.abortTask(this.newApiTaskAttemptContext);
        } else {
            this.committer.abortTask((TaskAttemptContext)this.oldApiTaskAttemptContext);
        }
    }

    public static class MROutputConfigBuilder {
        final Configuration conf;
        final Class<?> outputFormat;
        final boolean outputFormatProvided;
        boolean useNewApi;
        boolean getCredentialsForSinkFilesystem = true;
        String outputClassName = MROutput.class.getName();
        String outputPath;
        boolean doCommit = true;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private MROutputConfigBuilder(Configuration conf, Class<?> outputFormatParam) {
            this.conf = conf;
            if (outputFormatParam != null) {
                this.outputFormatProvided = true;
                this.outputFormat = outputFormatParam;
                if (OutputFormat.class.isAssignableFrom(outputFormatParam)) {
                    this.useNewApi = false;
                    return;
                } else {
                    if (!org.apache.hadoop.mapreduce.OutputFormat.class.isAssignableFrom(outputFormatParam)) throw new TezUncheckedException("outputFormat must be assignable from either org.apache.hadoop.mapred.OutputFormat or org.apache.hadoop.mapreduce.OutputFormat Given: " + outputFormatParam.getName());
                    this.useNewApi = true;
                }
                return;
            }
            this.outputFormatProvided = false;
            this.useNewApi = conf.get("mapred.reducer.new-api") == null ? conf.getBoolean("mapred.mapper.new-api", true) : conf.getBoolean("mapred.reducer.new-api", true);
            try {
                if (this.useNewApi) {
                    String outputClass = conf.get("mapreduce.job.outputformat.class");
                    if (StringUtils.isEmpty((String)outputClass)) {
                        throw new TezUncheckedException("no outputFormat setting on Configuration, useNewAPI:" + this.useNewApi);
                    }
                    this.outputFormat = conf.getClassByName(outputClass);
                    Preconditions.checkState((boolean)org.apache.hadoop.mapreduce.OutputFormat.class.isAssignableFrom(this.outputFormat), (Object)"outputFormat must be assignable from org.apache.hadoop.mapreduce.OutputFormat");
                } else {
                    String outputClass = conf.get("mapred.output.format.class");
                    if (StringUtils.isEmpty((String)outputClass)) {
                        throw new TezUncheckedException("no outputFormat setting on Configuration, useNewAPI:" + this.useNewApi);
                    }
                    this.outputFormat = conf.getClassByName(outputClass);
                    Preconditions.checkState((boolean)OutputFormat.class.isAssignableFrom(this.outputFormat), (Object)"outputFormat must be assignable from org.apache.hadoop.mapred.OutputFormat");
                }
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            this.initializeOutputPath();
        }

        private MROutputConfigBuilder setOutputPath(String outputPath) {
            if (!FileOutputFormat.class.isAssignableFrom(this.outputFormat) && !org.apache.hadoop.mapred.FileOutputFormat.class.isAssignableFrom(this.outputFormat)) {
                throw new TezUncheckedException("When setting outputPath the outputFormat must be assignable from either org.apache.hadoop.mapred.FileOutputFormat or org.apache.hadoop.mapreduce.lib.output.FileOutputFormat. Otherwise use the non-path config builder. Given: " + this.outputFormat.getName());
            }
            this.conf.set("mapreduce.output.fileoutputformat.outputdir", outputPath);
            this.outputPath = outputPath;
            return this;
        }

        private void initializeOutputPath() {
            Preconditions.checkState((!this.outputFormatProvided ? 1 : 0) != 0, (Object)"Should only be invoked when no outputFormat is provided");
            if (FileOutputFormat.class.isAssignableFrom(this.outputFormat) || org.apache.hadoop.mapred.FileOutputFormat.class.isAssignableFrom(this.outputFormat)) {
                this.outputPath = this.conf.get("mapreduce.output.fileoutputformat.outputdir");
            }
        }

        public DataSinkDescriptor build() {
            if ((FileOutputFormat.class.isAssignableFrom(this.outputFormat) || org.apache.hadoop.mapred.FileOutputFormat.class.isAssignableFrom(this.outputFormat)) && this.outputPath == null) {
                throw new TezUncheckedException("OutputPaths must be specified for OutputFormats based on " + FileOutputFormat.class.getName() + " or " + org.apache.hadoop.mapred.FileOutputFormat.class.getName());
            }
            List<URI> uris = null;
            if (this.getCredentialsForSinkFilesystem && this.outputPath != null) {
                try {
                    Path path = new Path(this.outputPath);
                    FileSystem fs = path.getFileSystem(this.conf);
                    Path qPath = fs.makeQualified(path);
                    uris = Collections.singletonList(qPath.toUri());
                }
                catch (IOException e) {
                    throw new TezUncheckedException((Throwable)e);
                }
            }
            DataSinkDescriptor ds = DataSinkDescriptor.create((OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.outputClassName).setUserPayload(this.createUserPayload())), (OutputCommitterDescriptor)(this.doCommit ? OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()) : null), null);
            if (this.conf.getBoolean("tez.runtime.convert.user-payload.to.history-text", false)) {
                ds.getOutputDescriptor().setHistoryText(TezUtils.convertToHistoryText((Configuration)this.conf));
            }
            if (uris != null) {
                ds.addURIsForCredentials(uris);
            }
            return ds;
        }

        public MROutputConfigBuilder getCredentialsForSinkFileSystem(boolean value) {
            this.getCredentialsForSinkFilesystem = value;
            return this;
        }

        public MROutputConfigBuilder setDoCommit(boolean value) {
            this.doCommit = value;
            return this;
        }

        MROutputConfigBuilder setOutputClassName(String outputClassName) {
            this.outputClassName = outputClassName;
            return this;
        }

        private UserPayload createUserPayload() {
            this.conf.setBoolean("mapred.reducer.new-api", this.useNewApi);
            this.conf.setBoolean("mapred.mapper.new-api", this.useNewApi);
            if (this.outputFormatProvided) {
                if (this.useNewApi) {
                    this.conf.set("mapreduce.job.outputformat.class", this.outputFormat.getName());
                } else {
                    this.conf.set("mapred.output.format.class", this.outputFormat.getName());
                }
            }
            MRHelpers.translateMRConfToTez(this.conf);
            try {
                return TezUtils.createUserPayloadFromConf((Configuration)this.conf);
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }
}

