/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.lib;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReaderTez;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;

@InterfaceAudience.Private
public class MRInputUtils {
    private static final Log LOG = LogFactory.getLog(MRInputUtils.class);

    public static JobSplit.TaskSplitMetaInfo[] readSplits(Configuration conf) throws IOException {
        JobSplit.TaskSplitMetaInfo[] allTaskSplitMetaInfo = SplitMetaInfoReaderTez.readSplitMetaInfo(conf, (FileSystem)FileSystem.getLocal((Configuration)conf));
        return allTaskSplitMetaInfo;
    }

    public static InputSplit getNewSplitDetailsFromEvent(MRRuntimeProtos.MRSplitProto splitProto, Configuration conf) throws IOException {
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        return MRInputHelpers.createNewFormatSplitFromUserPayload(splitProto, serializationFactory);
    }

    public static InputSplit getNewSplitDetailsFromDisk(JobSplit.TaskSplitIndex splitMetaInfo, JobConf jobConf, TezCounter splitBytesCounter) throws IOException {
        Class cls;
        Path file = new Path(splitMetaInfo.getSplitLocation());
        long offset = splitMetaInfo.getStartOffset();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        file = fs.makeQualified(file);
        LOG.info((Object)("Reading input split file from : " + file));
        FSDataInputStream inFile = fs.open(file);
        inFile.seek(offset);
        String className = Text.readString((DataInput)inFile);
        try {
            cls = jobConf.getClassByName(className);
        }
        catch (ClassNotFoundException ce) {
            IOException wrap = new IOException("Split class " + className + " not found");
            wrap.initCause(ce);
            throw wrap;
        }
        SerializationFactory factory = new SerializationFactory((Configuration)jobConf);
        Deserializer deserializer = factory.getDeserializer(cls);
        deserializer.open((InputStream)inFile);
        InputSplit split = (InputSplit)deserializer.deserialize(null);
        long pos = inFile.getPos();
        if (splitBytesCounter != null) {
            splitBytesCounter.increment(pos - offset);
        }
        inFile.close();
        return split;
    }

    public static org.apache.hadoop.mapred.InputSplit getOldSplitDetailsFromDisk(JobSplit.TaskSplitIndex splitMetaInfo, JobConf jobConf, TezCounter splitBytesCounter) throws IOException {
        Class cls;
        Path file = new Path(splitMetaInfo.getSplitLocation());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        file = fs.makeQualified(file);
        LOG.info((Object)("Reading input split file from : " + file));
        long offset = splitMetaInfo.getStartOffset();
        FSDataInputStream inFile = fs.open(file);
        inFile.seek(offset);
        String className = Text.readString((DataInput)inFile);
        try {
            cls = jobConf.getClassByName(className);
        }
        catch (ClassNotFoundException ce) {
            IOException wrap = new IOException("Split class " + className + " not found");
            wrap.initCause(ce);
            throw wrap;
        }
        SerializationFactory factory = new SerializationFactory((Configuration)jobConf);
        Deserializer deserializer = factory.getDeserializer(cls);
        deserializer.open((InputStream)inFile);
        org.apache.hadoop.mapred.InputSplit split = (org.apache.hadoop.mapred.InputSplit)deserializer.deserialize(null);
        long pos = inFile.getPos();
        if (splitBytesCounter != null) {
            splitBytesCounter.increment(pos - offset);
        }
        inFile.close();
        return split;
    }

    @InterfaceAudience.Private
    public static org.apache.hadoop.mapred.InputSplit getOldSplitDetailsFromEvent(MRRuntimeProtos.MRSplitProto splitProto, Configuration conf) throws IOException {
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        return MRInputHelpers.createOldFormatSplitFromUserPayload(splitProto, serializationFactory);
    }
}

