/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezRootInputInitializer;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.RootInputUpdatePayloadEvent;

public class MRInputSplitDistributor
implements TezRootInputInitializer {
    private static final Log LOG = LogFactory.getLog(MRInputSplitDistributor.class);
    private boolean sendSerializedEvents;
    private MRRuntimeProtos.MRSplitsProto splitsProto;

    public List<Event> initialize(TezRootInputInitializerContext rootInputContext) throws IOException {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRHelpers.parseMRInputPayload(rootInputContext.getUserPayload());
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to parse MRInput payload into prot: " + sw.elapsedMillis()));
        }
        Configuration conf = MRHelpers.createConfFromByteString(userPayloadProto.getConfigurationBytes());
        JobConf jobConf = new JobConf(conf);
        boolean useNewApi = jobConf.getUseNewMapper();
        this.sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        LOG.info((Object)("Emitting serialized splits: " + this.sendSerializedEvents));
        this.splitsProto = userPayloadProto.getSplits();
        MRRuntimeProtos.MRInputUserPayloadProto.Builder updatedPayloadBuilder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder(userPayloadProto);
        updatedPayloadBuilder.clearSplits();
        ArrayList events = Lists.newArrayListWithCapacity((int)(this.splitsProto.getSplitsCount() + 1));
        RootInputUpdatePayloadEvent updatePayloadEvent = new RootInputUpdatePayloadEvent(updatedPayloadBuilder.build().toByteArray());
        events.add(updatePayloadEvent);
        int count = 0;
        for (MRRuntimeProtos.MRSplitProto mrSplit : this.splitsProto.getSplitsList()) {
            RootInputDataInformationEvent diEvent;
            if (this.sendSerializedEvents) {
                diEvent = new RootInputDataInformationEvent(count++, mrSplit.toByteArray());
            } else if (useNewApi) {
                InputSplit newInputSplit = MRInput.getNewSplitDetailsFromEvent(mrSplit, conf);
                diEvent = new RootInputDataInformationEvent(count++, (Object)newInputSplit);
            } else {
                org.apache.hadoop.mapred.InputSplit oldInputSplit = MRInput.getOldSplitDetailsFromEvent(mrSplit, conf);
                diEvent = new RootInputDataInformationEvent(count++, (Object)oldInputSplit);
            }
            events.add(diEvent);
        }
        return events;
    }
}

