/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.hadoop.mapred.MRCounters;

public class Utils {
    @InterfaceAudience.Private
    public static List<FileSystem.Statistics> getFsStatistics(Path path, Configuration conf) throws IOException {
        ArrayList<FileSystem.Statistics> matchedStats = new ArrayList<FileSystem.Statistics>();
        path = path.getFileSystem(conf).makeQualified(path);
        String scheme = path.toUri().getScheme();
        for (FileSystem.Statistics stats : FileSystem.getAllStatistics()) {
            if (!stats.getScheme().equals(scheme)) continue;
            matchedStats.add(stats);
        }
        return matchedStats;
    }

    public static Counters.Counter getMRCounter(TezCounter tezCounter) {
        Preconditions.checkNotNull((Object)tezCounter);
        return new MRCounters.MRCounter(tezCounter);
    }
}

