/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapred;

import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.common.Utils;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.api.TezTaskContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRReporter
implements Reporter {
    private TezTaskContext tezTaskContext;
    private InputSplit split;
    private boolean isProcessorContext = false;

    public MRReporter(TezProcessorContext tezProcContext) {
        this((TezTaskContext)tezProcContext, null);
        this.isProcessorContext = true;
    }

    public MRReporter(TezTaskContext tezTaskContext) {
        this(tezTaskContext, null);
    }

    public MRReporter(TezTaskContext tezTaskContext, InputSplit split) {
        this.tezTaskContext = tezTaskContext;
        this.split = split;
    }

    public void progress() {
    }

    public void setStatus(String status) {
    }

    public Counters.Counter getCounter(Enum<?> name) {
        return Utils.getMRCounter(this.tezTaskContext.getCounters().findCounter(name));
    }

    public Counters.Counter getCounter(String group, String name) {
        return Utils.getMRCounter(this.tezTaskContext.getCounters().findCounter(group, name));
    }

    public void incrCounter(Enum<?> key, long amount) {
        this.getCounter(key).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.getCounter(group, counter).increment(amount);
    }

    public InputSplit getInputSplit() throws UnsupportedOperationException {
        if (this.split == null) {
            throw new UnsupportedOperationException("Input only available on map");
        }
        return this.split;
    }

    public float getProgress() {
        return 0.0f;
    }
}

